[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / Mage Training Arena Example

This is the source code for the following package: [DZ - Mage Training Arena](https://deadzone.dev/package/253)

---

## main.js
```
/**
* Called when your script is initially started. It's a good place to setup variables
*/
function OnStart() {
}

/**
* Called every game tick which is roughly 0.6s. You should use this event for state management and for handling your main script logic
*/
function OnGameTick() {

    if(isInTeleRoom())
    {
        HandleTeleRoom();
    }
    else if(isInEnchantRoom())
    {
        HandleEnchantRoom();
    }
    else if(isInBonesRoom())
    {
        HandleBonesRoom();
    }
    else if(isInAlchRoom())
    {
        HandleAlchRoom();
    }
}

function HandleTeleRoom()
{
    if( PlayerHelper.isMoving() ) { return; }

    var guardianDone = Game.info.npc.getNearest([NPC_ID_MAZE_GUARDIAN_DONE]);
    if( guardianDone != null )
    {
        Utility.invokeLater(function () {
            Game.interact.npc.action(guardianDone, MenuAction.NPC_FIRST_OPTION);
        }, Utility.getDelay());
    }

    // Stand in the right spot
    var pos = Game.info.getHintArrowPoint();

    if( pos == null  )
    {
        Utility.print("cannae see moving closer");
        // We can't see an arrow, try walk closer
        WalkToMaze();
    }
    else
    {
        if( !Client.getLocalPlayer().getWorldLocation().equals(pos) )
        {
            Utility.invokeLater(function () {
                PlayerHelper.walkTo(pos);
            }, Utility.getDelay());      

            return;
        }
    }

    // Cast telegrab
    if( PlayerHelper.isPlayerIdle() )
    {
        var guardian = Game.info.npc.getNearest([NPC_ID_MAZE_GUARDIAN]);
        if( guardian != null )
        {
            Game.interact.spell.useOnNpc("Telekinetic Grab", guardian, Utility.getDelay());
        }
    }
}

function HandleEnchantRoom()
{
    if( PlayerHelper.isMoving() ) { return; }
    if( !PlayerHelper.isPlayerIdle() ) { return; }

    if( Game.info.inventory.hasItem(ITEM_ID_DRAGONSTONE, 1) )
    {
        Utility.invokeLater(function () {
            Game.interact.inventory.dropItem(ITEM_ID_DRAGONSTONE, -1);
        }, Utility.getDelay());

        return;
    }

    if( Game.info.inventory.isFull() )
    {
        var deposit = Game.info.gameObject.getNearest([GAME_OBJECT_DEPOSIT]);
        Utility.invokeLater(function () {
            Game.interact.gameObject.action(deposit, MenuAction.GAME_OBJECT_FIRST_OPTION);
        }, Utility.getDelay());
        return;
    }

    // Get the current bonus
    BlockType.ALL.forEach(function(block) {
        var item = block.itemId;

        if (Game.info.isWidgetVisible(block.widgetParent, block.widgetChild)) {

            var hasBlock = Game.info.inventory.hasItem(item);
            if( hasBlock )
            {
                Game.interact.spell.useOnItem(config.enchantType.getValue(), item, Utility.getDelay());
                return;
            }
            else
            {
                var pile = Game.info.gameObject.getNearest([block.objectId]);
                if( pile != null )
                {
                    Utility.invokeLater(function () {
                        Game.interact.gameObject.action(pile, MenuAction.GAME_OBJECT_FIRST_OPTION);
                    }, Utility.getDelay());

                    return;
                }
            }
        }
        else
        {
            Utility.invokeLater(function () {
                Game.interact.inventory.dropItem(item, -1);
            }, Utility.getDelay());
        }
    });
}

function HandleAlchRoom()
{
    if( PlayerHelper.isMoving() ) { return; }
    if( !PlayerHelper.isPlayerIdle() ) { return; }

    // Check to see which item is best to grab
    var bestId = getBestAlch();

    // We just have to click a random one
    var cupboards = Game.info.gameObject.getByName(["Cupboard"], true);

    var arrow = Game.info.getHintArrowPoint();
    if( arrow != null )
    {
        // Do we have anything in our inventory to alch
        var hasItem = Game.info.inventory.hasItem(bestId);
        if( hasItem )
        {
            Game.interact.spell.useOnItem("High Level Alchemy", bestId, Utility.getDelay());
            return;
        }

        // Make sure we don't soft lock on a full inventory
        if( Game.info.inventory.getSize() > 23 )
        {
            if( !PlayerHelper.isOnInventoryTab() )
            {
                Utility.invokeLater(function() {
                    PlayerHelper.setTab(TabType.INVENTORY);
                 }, Utility.getDelay());
                 return;
            }

            for (const id of ITEM_IDS_ALCHABLES) {
                if( Game.info.inventory.hasItem(id) )
                {
                    Utility.invokeLater(function () {
                        Game.interact.inventory.dropItem(id, -1);
                    }, Utility.getDelay());
                    return;
                }
            }
        }

        // Grab some more items from the cupboard
        var selected = Game.info.gameObject.getAtWorldPosition(arrow, null);
        if( selected != null )
        {
            var delay = Utility.getDelay();

            Utility.invokeLater(function () {
                Game.interact.gameObject.action(selected, MenuAction.GAME_OBJECT_SECOND_OPTION);
            }, delay);

        }

        return;
    }

    // Everything is unknown, to start, click the nearest cupboard, just grab 1 because it may be wrong
    if( cupboards != null && cupboards.length > 0 )
    {
        Utility.invokeLater(function () {
            Game.interact.gameObject.action(cupboards[0], MenuAction.GAME_OBJECT_FIRST_OPTION);
        }, Utility.getDelay());
    }
}

function HandleBonesRoom()
{
    if( PlayerHelper.isMoving() ) { return; }

    // Should we eat?
    if( config.bonesEat.getValue() == true )
    {
        // Have we hit the eat threshold
        if( Client.getBoostedSkillLevels(Skill.HITPOINTS) < config.bonesEatVal.getValue() )
        {
            // Do we have any food to eat?
            var food = BonesEnumToItemID[config.bonesSpell.getValue()];

            if( Game.info.inventory.hasItem(food, 1) )
            {
                Utility.invokeLater(function () {
                    Game.interact.inventory.consumeItem(food);
                }, Utility.getDelay());

                return;
            }
        }
    }

    // Do we have enough fruit to deposit
    if( Game.info.inventory.isFull() )
    {
        var chute = Game.info.gameObject.getNearest([GAME_OBJECT_FOOD_CHUTE]);

        Utility.invokeLater(function () {
            Game.interact.gameObject.action(chute, MenuAction.GAME_OBJECT_FIRST_OPTION);
        }, Utility.getDelay());

        return;
    }

    var totalBones = 0;
    for( const bonesId of ITEM_ID_ANIMAL_BONES )
    {
        var count = Game.info.inventory.getItemCount(bonesId);
        totalBones = totalBones + count;
    }

    // We have enough bones to cast
    if( totalBones >= config.bonesToPick.getValue() )
    {
        Utility.invokeLater(function () {
            Game.interact.spell.use(config.bonesSpell.getValue());
        }, Utility.getDelay());
    }
    else
    {
        // Grab more bones from the pile
        var pile = Game.info.gameObject.getAtWorldPosition(BONES_PILE_POINT, GAME_OBJECT_ALL_BONES);
        if( pile != null )
        {
            Utility.invokeLater(function () {
                Game.interact.gameObject.action(pile, MenuAction.GAME_OBJECT_FIRST_OPTION);
            }, Utility.getDelay());
        }
    }
}

/**
* Called when your script is stopped.
*/
function OnShutdown() {

}
```

## utilities.js

```

/*
    Telegrab room
*/
NPC_ID_MAZE_GUARDIAN = 6777;
NPC_ID_MAZE_GUARDIAN_DONE = 6779;
NPC_ID_TELE_GUARDIAN = 5979;

MAZE_WALL_ID = 10755;

function isInTeleRoom()
{
    var w = Game.info.getWidget(198, 2);
    return w != null && Game.info.isWidgetVisible(198, 2);
}

function WalkToMaze()
{
    var maze = Game.info.wallObject.getNearest([MAZE_WALL_ID]);
    if( maze != null )
    {
        Utility.invokeLater(function () {
            PlayerHelper.walkTo(maze.getWorldLocation());
        }, Utility.getDelay());
    }
}

/*
    Enchant room
*/
ENCHANT_REGION = 13462;

function isInEnchantRoom()
{
    var player = Client.getLocalPlayer();

    return (player != null && player.getWorldLocation().getRegionID() == ENCHANT_REGION && player.getWorldLocation().getPlane() == 0);
}

WIDGET_ID_BONUS_BLOCKS_PARENT = 195;
WIDGET_ID_BONUS_BLOCKS_CHILD = 10;

GAME_OBJECT_DEPOSIT = 23698;

ITEM_ID_ORB = 6902;
ITEM_ID_DRAGONSTONE = 6903;

function BlockType(name, model_id, objectId, widgetParent, widgetChild, itemId) {
    this.name = name;
    this.model_id = model_id;
    this.objectId = objectId;
    this.widgetParent = widgetParent;
    this.widgetChild = widgetChild;
    this.itemId = itemId;
}

// Update with actual widget IDs
BlockType.RED   = new BlockType('Red',   10605, 23697, 195, 14, 6901);
BlockType.GREEN = new BlockType('Green', 10597, 23695, 195, 12, 6898);
BlockType.BLUE  = new BlockType('Blue',  10602, 23696, 195, 16, 6900);
BlockType.GOLD  = new BlockType('Gold',  10596, 23694, 195, 10, 6899);
BlockType.ALL = [BlockType.RED, BlockType.GREEN, BlockType.BLUE, BlockType.GOLD];

/*
    Alch room
*/

ALCH_REGION = 13462;

function isInAlchRoom()
{
    var player = Client.getLocalPlayer();

    return (player != null && player.getWorldLocation().getRegionID() == ALCH_REGION && player.getWorldLocation().getPlane() == 2);
}

ITEM_ID_ADDY_HELM = 6895;
ITEM_ID_EMERALD = 6896;
ITEM_ID_ADDY_KITE = 6894;
ITEM_ID_LEATHER_BOOTS = 6893;
ITEM_ID_RUNE_LONG = 6897;

ITEM_IDS_ALCHABLES = [
  ITEM_ID_ADDY_HELM,
  ITEM_ID_EMERALD,
  ITEM_ID_ADDY_KITE,
  ITEM_ID_LEATHER_BOOTS,
  ITEM_ID_RUNE_LONG
];

const ALCH_MAP = {
  "Leather Boots:": ITEM_ID_LEATHER_BOOTS,
  "Adamant Kiteshield:": ITEM_ID_ADDY_KITE,
  "Adamant Helm:": ITEM_ID_ADDY_HELM,
  "Emerald:": ITEM_ID_EMERALD,
  "Rune Longsword:": ITEM_ID_RUNE_LONG
};

MTA_ALCH_WIDGET = 194;
INFO_ITEM_START = 7;
INFO_POINT_START = 12;
BEST_POINTS = 30;
INFO_LENGTH = 5;

function getBestAlch()
{
    for (var i = 0; i < INFO_LENGTH; i++)
    {
        var textWidget = Game.info.getWidget(MTA_ALCH_WIDGET, INFO_ITEM_START + i);
        if (textWidget == null)
        {
            return null;
        }

        var item = textWidget.getText();
        var pointsWidget = Game.info.getWidget(MTA_ALCH_WIDGET, INFO_POINT_START + i);
        var points = parseInt(pointsWidget.getText());

        if (points == BEST_POINTS)
        {
            const itemId = ALCH_MAP[item];

            if (itemId !== undefined) {
                return itemId;
            }
        }
    }

    return null;
}

/*
    Bones room
*/

NPC_ID_GRAVEYARD = 5982;
GAME_OBJECT_FOOD_CHUTE = 10735;
BONES_PILE_POINT = new WorldPoint(3353, 9637, 1);
MTA_GRAVEYARD_REGION = 13462;

ITEM_ID_ANIMAL_BONES = [
    6904,
    6905,
    6906,
    6907
];

GAME_OBJECT_ALL_BONES = [
    10725,
    10726,
    10727,
    10728,
];

function isInBonesRoom()
{
    var player = Client.getLocalPlayer();

    return (player != null && player.getWorldLocation().getRegionID() == MTA_GRAVEYARD_REGION && player.getWorldLocation().getPlane() == 1);
}
```

## config.js

```
// Below, you define config items as children of the config object. They have multiple overrides depending on the data type you want to use.
// You define the data type by providing the default value. Supported data types are strings (text), integers (numbers), booleans (tickbox), and lists (dropdown)
// Your config items are updated automatically when changed through the DeadZone Community Package Manager in-game
// Simply define config items below and you can use them anywhere in your package!

/**
* An object which defines list items we can use for one of our config item types
*/
const EnchantEnum = {
    Lvl_1: "Lvl-1 Enchant",  // Sapphire
    Lvl_2: "Lvl-2 Enchant",  // Emerald
    Lvl_3: "Lvl-3 Enchant",  // Ruby
    Lvl_4: "Lvl-4 Enchant",  // Diamond
    Lvl_5: "Lvl-5 Enchant",  // Dragonstone
    Lvl_6: "Lvl-6 Enchant",  // Onyx
    Lvl_7: "Lvl-7 Enchant",  // Zenyte
};

const BonesEnum = {
    Bones_To_Bananas: "Bones to Bananas",
    Bones_To_Peaches: "Bones to Peaches",
};

const BonesEnumToItemID = {
    "Bones to Bananas": 1963,  // banana
    "Bones to Peaches": 6883,  // peach
};

/**
* Holds references to all our config items. It is required to have the below config object or your package will not work in-game!
* In addition, don't modify the config object at runtime scuh as adding / removing items. Config items must be defined below and modifying the object at runtime will not be reflected in-game!
*/
const config = {
    enchantType : ConfigItem.createList("enchantType", "Enchant", "Enchant Spell", "Which spell to use for Enchanting", Object.values(EnchantEnum), EnchantEnum.Lvl_1),
    bonesSpell : ConfigItem.createList("bonesSpell", "Bones", "Bones Spell", "Which spell to use for converting bones", Object.values(BonesEnum), BonesEnum.Bones_To_Bananas),
    bonesEat : ConfigItem.createBoolean("bonesEat", "Bones", "Auto Eat", "Should we eat the Bananas/Peaches?", false),
    bonesEatVal : ConfigItem.createIntegerRange("bonesEatVal", "Bones", "Eat at HP lvl", "What level HP should we start eating at", 1, 97, 35),
    bonesToPick : ConfigItem.createIntegerRange("bonesToPick", "Bones", "Bones Quantity", "How many bones to pick up", 1, 24, 8)
};
```
