[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / Getting started

# Introduction
DeadZone Community Packages uses an online editor to allow you to develop plugins. We've tried to make it as easy as possible to get started and not have to worry about setting up Java, IDEs, APIs and mess with your system.

Everything you need is contained inside the existing DeadZone Plugins and the website, https://deadzone.dev/

# Creating a package
- First off, head over to https://deadzone.dev/ and Sign in via Discord.
- Navigate to Manage -> Private and click 'Create Package'.
- Fill out your package information

NOTE: Anyone is able to make a private package. Only approved developers can publish to the store.

You should now see the package template:
![Community Packages Editor](_media/ide.png "Community Packages Editor")

# Understanding the editor
## main
This is where the bulk of your package code will reside, it should contain the main logic, events and game interactions.

## utilities
Use this file for writing helper functions, it helps to de-clutter the main file by offloading some of the smaller functions into here.

## config
Your package can define various configuration options, use this file to keep all the definitions together.

## metadata
Used for if you want to update the package name, image, description, etc.

## publish
When you want to make a package public, you can send it off to review. Once it has been approved by DeadZone staff, it will be made available on the store.

# Game Events
If you're wondering where to begin, it's important to understand events.

In the game a lot of actions are triggered by a specific 'event'. This can be when an NPC spawns, object appears, an animation changes or much more. You can use these to write code which reacts the game world. For example inside the onAnimationChanged you could check if an NPC has a specific 'attack' animation and call PlayerHelper.activatePrayer.

You can see [GameEventType](DeadZoneAPI.Enumeration.GameEventType.md) for a full list of events.

There's also some important events that the package can't function without. These already exist in the template:
- **OnStart** (when the package is started)
- **OnStop** (when the package is stopped)
- **OnGameTick** (a game tick, roughly 600ms)

You should be doing the majority of your code inside of OnGameTick.

## Running your package
Load up DeadZone as normal and you should see a new icon in the side panel.

Inside this panel it will show you both **Private** and **Purchased** packages.

![Community Packages Ingame](_media/ingame_panel.png "Community Packages Ingame")

From here you can press 'Install' and the package will show under 'Installed', no different to other plugins.
