[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / Discord Webhooks

## How can my package use Discord webhooks?
We're created a handful of helper functions which can help you in implementing Discord Webhook functionality.

⚠️ WARNING ⚠️
Never embed a webhook URL directly, they should be config parameters.

For simple calls you can use:

```js
Utility.notify.discord.send(config.webhookUrl.getValue(), // Webhook from user's config
							"Hello world!", // Attach a message
							true,	// Attach a screenshot 
							"324515629233209344" // UUID to @
							);
```

And for more advanced you can use the full Discord payload. Here's a small example
```js
Utility.notify.discord.sendCustom(
	config.webhookUrl.getValue(),
	{
		content: "Daily Summary Report",
		embeds: [
			{
				title: "Combat Stats",
				color: 0xff0000, // Red
				fields: [
					{ name: "Kills", value: "150", inline: true },
					{ name: "Deaths", value: "2", inline: true }
				]
			},
			{
				title: "Loot Summary",
				color: 0xffd700, // Gold
				fields: [
					{ name: "Total GP", value: "5.2M", inline: true },
					{ name: "Rare Drops", value: "3", inline: true }
				]
			}
		]
	},
	false // no screenshot
);
```

![Webhooks example](_media/example.png "Webhooks example")

## Additional Resources

- [Discord Markdown Reference](https://support.discord.com/hc/en-us/articles/210298617-Markdown-Text-101)
- [Discord Webhook Guide](https://discord.com/developers/docs/resources/webhook)
