[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / Custom Menu Entries

## What are Menu Entries
Menu entries are the options you see when you right-click on objects, NPCs, items, or other players in the game.

Examples: "Walk here", "Attack Goblin", "Talk-to Banker", "Use Item -> Object".

Making your own is a great way to add extra configurability to your packages. We use them for various actions in DeadZone, for example Skilling Radius, Register Cannon, Mark NPC, etc.

---

The idea here is that you monitor for when Menu Entries are created, and inject a new one.

Typically you want to look for an action related to yours. For example if you see there is a menu entry for 'Place Trap' you know it'll be related to Hunter traps and you can inject your own.

Here is a very basic example which will work on ANY tile.

```
function OnMenuEntryAdded(event) {
    if(event.getOption() == "Walk here") {
        var entry = MenuEntry.create("Left side", "Right side", 123, -1, -1, -1, false);
        Utility.insertRightClickMenu(entry, 255, 0, 0, 0);
    }
}
```

So when the game goes to create menu entries (right click menu) it will inject our custom option 'Left side Right Side' which shows like this.

The information in the Menu Entry isn't particularly important, it's just to uniquely identify it as yours.

![Custom menu entry](_media/custom_menu_entry.png "Custom menu entry")

Now we need to run an action when the new option is selected.

We do this with another event, **MenuOptionClicked**.

```
function OnMenuOptionClicked(event) {
    if(event.getOption() == "Left side") {
        // I can trigger my action here for example grab the selected tile
        var tile = Client.getSelectedSceneTile();
    }
}
```

Here we are looking for the Menu Entry we defined earlier, you can use any unique piece of information but we find it's generally easier to look for the text.

From here you can run your custom action, as an example I grab the tile that they're hovering over.
