[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / [DeadZoneAPI](DeadZoneAPI.md) / [Utility](DeadZoneAPI.Namespace.Utility.md) / calculateSkillingBreak

# Function: calculateSkillingBreak()

> **calculateSkillingBreak**(`chance`, `maxRange`, `forceCustom?`, `minTicks?`, `maxTicks?`): `boolean`

To trigger a skilling break, we generate a number between 1 and the maxRange. If the number generated is less than or equal to the chance, we trigger a skilling break. For example, if you were to set the chance to 5 and the max range to 100, there is a 5% chance of triggering a skilling break each time it's called. Furthermore, if the user has DZ API -> Custom Skilling Breaks enabled, it will use those frequency values rather than your ones.

We recommend calling this method for each major action when convenient with a reasonable chance to trigger a break, typically at the start of a cycle or at points where it seems reasonable to stop. Once a skilling break has been triggered, you should stop execution until [isSkillingBreakActive](DeadZoneAPI.Utility.Function.isSkillingBreakActive.md) returns false

## Parameters

### chance

`number`

The generated value is must be less than or equal to the chance to trigger a skilling break

### maxRange

`number`

The maximum range of the generated value

### forceCustom?

`boolean`

Optional, if omitted, chance / maxRange to trigger a skilling break can be overriden by onfiguration in DZ API. If enabled, always use provided chance / maxRange regardless of API configuration.

### minTicks?

`number`

Optional, if omitted, will use skilling break timing defined in DZ API. Determines the min break time in ticks when a skilling break is triggered

### maxTicks?

`number`

Optional, if omitted, will use skilling break timing defined in DZ API. Determines the max break time in ticks when a skilling break is triggered

## Returns

`boolean`

true if a skilling break was triggered, false otherwise
