[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / [DeadZoneAPI](DeadZoneAPI.md) / Widget

# Interface: Widget

## Methods

### getId()

> **getId**(): `number`

#### Returns

`number`

***

### getType()

> **getType**(): `number`

#### Returns

`number`

***

### getChild()

> **getChild**(): `Widget`

#### Returns

`Widget`

***

### getChildren()

> **getChildren**(): `Widget`[]

#### Returns

`Widget`[]

***

### getDynamicChildren()

> **getDynamicChildren**(): `Widget`[]

#### Returns

`Widget`[]

***

### getStaticChildren()

> **getStaticChildren**(): `Widget`[]

#### Returns

`Widget`[]

***

### getNestedChildren()

> **getNestedChildren**(): `Widget`[]

#### Returns

`Widget`[]

***

### getParent()

> **getParent**(): `Widget`

#### Returns

`Widget`

***

### getParentId()

> **getParentId**(): `number`

#### Returns

`number`

***

### getIndex()

> **getIndex**(): `number`

#### Returns

`number`

***

### getItemId()

> **getItemId**(): `number`

#### Returns

`number`

***

### getItemQuantity()

> **getItemQuantity**(): `number`

#### Returns

`number`

***

### getText()

> **getText**(): `string`

#### Returns

`string`

***

### getTextColor()

> **getTextColor**(): `number`

#### Returns

`number`

***

### getOpacity()

> **getOpacity**(): `number`

#### Returns

`number`

***

### getName()

> **getName**(): `string`

#### Returns

`string`

***

### getFontId()

> **getFontId**(): `number`

#### Returns

`number`

***

### getAnimationId()

> **getAnimationId**(): `number`

#### Returns

`number`

***

### getActions()

#### Call Signature

> **getActions**(): `string`[]

##### Returns

`string`[]

#### Call Signature

> **getActions**(): `string`[]

##### Returns

`string`[]

***

### isHidden()

> **isHidden**(): `boolean`

#### Returns

`boolean`

***

### isSelfHidden()

> **isSelfHidden**(): `boolean`

#### Returns

`boolean`

***

### hasListener()

> **hasListener**(): `boolean`

#### Returns

`boolean`

***

### isFilled()

> **isFilled**(): `boolean`

#### Returns

`boolean`

***

### isIf3()

> **isIf3**(): `boolean`

#### Returns

`boolean`

***

### getCanvasLocation()

> **getCanvasLocation**(): [`Point`](DeadZoneAPI.Interface.Point.md)

#### Returns

[`Point`](DeadZoneAPI.Interface.Point.md)

***

### getWidth()

> **getWidth**(): `number`

#### Returns

`number`

***

### getHeight()

> **getHeight**(): `number`

#### Returns

`number`

***

### getBounds()

> **getBounds**(): [`Rectangle`](DeadZoneAPI.Interface.Rectangle.md)

#### Returns

[`Rectangle`](DeadZoneAPI.Interface.Rectangle.md)

***

### setName()

> **setName**(`name`): `Widget`

Sets the name of the widget

#### Parameters

##### name

`string`

#### Returns

`Widget`

***

### setText()

> **setText**(`text`): `Widget`

Sets the text displayed on this widget.

#### Parameters

##### text

`string`

#### Returns

`Widget`

***

### setTextColor()

> **setTextColor**(`textColor`): `Widget`

Sets the text color to the specified RGB24 number

#### Parameters

##### textColor

`number`

#### Returns

`Widget`

***

### setAction()

> **setAction**(`index`, `action`): `void`

Creates a menu option on the widget

#### Parameters

##### index

`number`

The index of the menu

##### action

`string`

The verb to be displayed next to the widget's name in the context menu

#### Returns

`void`

***

### clearActions()

> **clearActions**(): `void`

Clear the menu options on a widget.

#### Returns

`void`

***

### revalidate()

> **revalidate**(): `void`

Recomputes this widget's x/y/w/h, excluding scroll

#### Returns

`void`

***

### revalidateScroll()

> **revalidateScroll**(): `void`

Recomputes this widget's group's x/y/w/h including scroll

#### Returns

`void`

***

### deleteAllChildren()

> **deleteAllChildren**(): `void`

Removes all of this widget's dynamic children

#### Returns

`void`

***

### setPos()

> **setPos**(`x`, `y`): `Widget`

Sets the X/Y coordinates

#### Parameters

##### x

`number`

##### y

`number`

#### Returns

`Widget`

***

### contains()

> **contains**(`point`): `boolean`

Checks if the passed canvas points is inside of this widget's

#### Parameters

##### point

[`Point`](DeadZoneAPI.Interface.Point.md)

the canvas point

#### Returns

`boolean`

true if this widget contains the point, false otherwise
