[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / [DeadZoneAPI](DeadZoneAPI.md) / ObjectComposition

# Interface: ObjectComposition

## Methods

### getId()

> **getId**(): `number`

Gets ID for the object.

#### Returns

`number`

***

### getName()

> **getName**(): `string`

Gets the name of the object.

#### Returns

`string`

***

### getActions()

> **getActions**(): `string`[]

The 5 menuops this NPC has when in world. Index 0 corresponds to
[MenuAction.GAME\_OBJECT\_FIRST\_OPTION](DeadZoneAPI.Enumeration.MenuAction.md#game_object_first_option), Index 2 to
[MenuAction.GAME\_OBJECT\_SECOND\_OPTION](DeadZoneAPI.Enumeration.MenuAction.md#game_object_second_option) and so on.

#### Returns

`string`[]

***

### getMapSceneId()

> **getMapSceneId**(): `number`

#### Returns

`number`

***

### getMapIconId()

> **getMapIconId**(): `number`

#### Returns

`number`

***

### getImpostorIds()

> **getImpostorIds**(): `number`[]

Get the IDs of NPCs this can transform into, depending on a [Varbit](DeadZoneAPI.Enumeration.Varbit.md) or [VarPlayer](DeadZoneAPI.Enumeration.VarPlayer.md) id.

#### Returns

`number`[]

null if this object can't transform

***

### getImpostor()

> **getImpostor**(): `ObjectComposition`

Get the object composition the player's state says this object should transmogrify into.

#### Returns

`ObjectComposition`

#### Throws

NullPointerException if [getImpostorIds](#getimpostorids) is null

***

### getVarbitId()

> **getVarbitId**(): `number`

Gets the [Varbit](DeadZoneAPI.Enumeration.Varbit.md) used to switch this multiloc, or `-1` if this is not switched by a Varbit

#### Returns

`number`

#### See

 - [getImpostor](#getimpostor)
 - [getImpostorIds](#getimpostorids)

***

### getVarPlayerId()

> **getVarPlayerId**(): `number`

Gets the [Varbit](DeadZoneAPI.Enumeration.VarPlayer.md) used to switch this multiloc, or `-1` if this is not switched by a VarPlayer

#### Returns

`number`

#### See

 - [getImpostor](#getimpostor)
 - [getImpostorIds](#getimpostorids)

***

### getSizeX()

> **getSizeX**(): `number`

Get the size of the object on the X-axis in tiles

#### Returns

`number`

***

### getSizeY()

> **getSizeY**(): `number`

Get the size of the object on the Y-axis in tiles

#### Returns

`number`
