[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / [DeadZoneAPI](DeadZoneAPI.md) / NPCComposition

# Interface: NPCComposition

## Methods

### getName()

> **getName**(): `string`

Gets the name of the NPC.

#### Returns

`string`

***

### getModels()

> **getModels**(): `number`[]

Gets the model IDs that compose this NPC.

#### Returns

`number`[]

***

### getChatheadModels()

> **getChatheadModels**(): `number`[]

Gets the model IDs that compose this NPC's chathead.

#### Returns

`number`[]

***

### getActions()

> **getActions**(): `string`[]

The 5 menuops this NPC has when in world. Index 0 corresponds to
[MenuAction.NPC\_FIRST\_OPTION](DeadZoneAPI.Enumeration.MenuAction.md#npc_first_option), Index 2 to
[MenuAction.NPC\_SECOND\_OPTION](DeadZoneAPI.Enumeration.MenuAction.md#npc_second_option) and so on.

#### Returns

`string`[]

***

### isInteractible()

> **isInteractible**(): `boolean`

NPC can be interacting with via menu options

#### Returns

`boolean`

***

### isMinimapVisible()

> **isMinimapVisible**(): `boolean`

Gets whether the NPC is visible on the mini-map.

#### Returns

`boolean`

***

### getId()

> **getId**(): `number`

Gets the ID of the NPC.

#### Returns

`number`

***

### getCombatLevel()

> **getCombatLevel**(): `number`

#### Returns

`number`

the combat level, -1 if none

***

### getConfigs()

> **getConfigs**(): `number`[]

Get the IDs of NPCs this can transform into, depending on a [Varbit](DeadZoneAPI.Enumeration.Varbit.md) or [VarPlayer](DeadZoneAPI.Enumeration.VarPlayer.md) id

#### Returns

`number`[]

***

### transform()

> **transform**(): `NPCComposition`

Get the NPC composition the player's state says this NPC should
transmogrify into.

#### Returns

`NPCComposition`

#### Throws

NullPointerException if [getConfigs](#getconfigs) is null

***

### getSize()

> **getSize**(): `number`

How many tiles wide this NPC is

#### Returns

`number`

***

### isFollower()

> **isFollower**(): `boolean`

If the npc is a follower, such as a pet. Is affected by the
"Move follower options lower down" setting.

#### Returns

`boolean`

***

### getFootprintSize()

> **getFootprintSize**(): `number`

Get the npc footprint size

#### Returns

`number`

***

### getWidthScale()

> **getWidthScale**(): `number`

Horizontal scaling of the npc model (1/128th of a tile).

#### Returns

`number`

***

### getHeightScale()

> **getHeightScale**(): `number`

Vertical scaling of the npc model (1/128th of a tile).

#### Returns

`number`

***

### getStats()

> **getStats**(): `number`[]

Get the npc's stats

#### Returns

`number`[]

#### See

 - [STAT\_ATTACK](#stat_attack)
 - [STAT\_DEFENCE](#stat_defence)
 - [STAT\_STRENGTH](#stat_strength)
 - [STAT\_HITPOINTS](#stat_hitpoints)
 - [STAT\_RANGED](#stat_ranged)
 - [STAT\_MAGIC](#stat_magic)

## Properties

### STAT\_ATTACK

> **STAT\_ATTACK**: `number`

***

### STAT\_DEFENCE

> **STAT\_DEFENCE**: `number`

***

### STAT\_STRENGTH

> **STAT\_STRENGTH**: `number`

***

### STAT\_HITPOINTS

> **STAT\_HITPOINTS**: `number`

***

### STAT\_RANGED

> **STAT\_RANGED**: `number`

***

### STAT\_MAGIC

> **STAT\_MAGIC**: `number`
