[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / [DeadZoneAPI](DeadZoneAPI.md) / ItemComposition

# Interface: ItemComposition

## Methods

### getName()

> **getName**(): `string`

Gets the item's name as it appears in game.
On a members server, this is always the item's actual name.
On a free server, this will be the actual name, with " (Members)" appended to it, e.g. Twisted bow (Members)

#### Returns

`string`

the name of the item as it appears in game

***

### getMembersName()

> **getMembersName**(): `string`

Gets the real item name, even if the player is on a F2P server.
Unlike [getName](#getname), this will not have " (Members)" at the end on F2P servers.

#### Returns

`string`

the real name of the item

***

### getId()

> **getId**(): `number`

Returns the ID of this item. Please note, it may be the Noted / Placeholder variant of this item. We recommend using [canonicalize](DeadZoneAPI.Game.info.itemManager.Function.canonicalize.md) to find an item's real ID from this value

#### Returns

`number`

***

### getNote()

> **getNote**(): `number`

Gets a value specifying whether the item is noted.

#### Returns

`number`

799 if noted, -1 otherwise

***

### getLinkedNoteId()

> **getLinkedNoteId**(): `number`

Gets the item ID of the noted or unnoted variant of this item.

Calling this method on a noted item will result in the ID of itself
in unnoted form, and on an unnoted item its noted variant.

#### Returns

`number`

the noted or unnoted variant of this item

***

### getPlaceholderId()

> **getPlaceholderId**(): `number`

Gets the item ID of the normal or placeholder variant of this item.

Calling this method on a normal item will result in the ID of itself
in placeholder form, and on a placeholder item its normal variant.

#### Returns

`number`

the normal or placeholder variant of this item

***

### getPlaceholderTemplateId()

> **getPlaceholderTemplateId**(): `number`

Gets a value specifying whether the item is a placeholder.

#### Returns

`number`

14401 if placeholder, -1 otherwise

***

### getPrice()

> **getPrice**(): `number`

Gets the store price of the item.

Although not all items can be found in a store, they have a store price
which can be used to calculate high and low alchemy values. Multiplying
the price by `0.6` and `0.4` gives these high and low
alchemy values, respectively. Use [getItemPrice](DeadZoneAPI.Game.info.itemManager.Function.getItemPrice.md) to return the GE / WIKI price of an item

#### Returns

`number`

the general store value of the item

***

### getHaPrice()

> **getHaPrice**(): `number`

Get the high alchemy price for this item. All items have a high alchemy price,
but not all items can be alched.

#### Returns

`number`

the high alch price

***

### isMembers()

> **isMembers**(): `boolean`

Checks whether the item is members only.

#### Returns

`boolean`

true if members only, false otherwise.

***

### isStackable()

> **isStackable**(): `boolean`

Checks whether the item is able to stack in a players inventory.

#### Returns

`boolean`

true if stackable, false otherwise

***

### isTradeable()

> **isTradeable**(): `boolean`

Returns whether or not the item can be sold on the grand exchange.

#### Returns

`boolean`

***

### getInventoryActions()

> **getInventoryActions**(): `string`[]

Gets an array of possible right-click menu actions the item
has in a player inventory.

#### Returns

`string`[]

the inventory menu actions

***

### getShiftClickActionIndex()

> **getShiftClickActionIndex**(): `number`

Gets the menu action index of the shift-click action.

#### Returns

`number`

the index of the shift-click action

***

### setShiftClickActionIndex()

> **setShiftClickActionIndex**(`shiftClickActionIndex`): `void`

Sets the menu action index of the shift-click action.

#### Parameters

##### shiftClickActionIndex

`number`

the new index of the shift-click action

#### Returns

`void`

***

### getInventoryModel()

> **getInventoryModel**(): `number`

Gets the model ID of the inventory item.

#### Returns

`number`

the model ID
