[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / [DeadZoneAPI](DeadZoneAPI.md) / Varbit

# Enumeration: Varbit

Contains all documented Varbit IDs which are used by either Runelite or DeadZone

## Banking

### BANK\_REARRANGE\_MODE

> **BANK\_REARRANGE\_MODE**: `3959`

***

### CURRENT\_BANK\_TAB

> **CURRENT\_BANK\_TAB**: `4150`

***

### BANK\_QUANTITY\_TYPE

> **BANK\_QUANTITY\_TYPE**: `6590`

***

### BANK\_REQUESTEDQUANTITY

> **BANK\_REQUESTEDQUANTITY**: `3960`

***

### BANK\_LEAVEPLACEHOLDERS

> **BANK\_LEAVEPLACEHOLDERS**: `3755`

***

### BANK\_TAB\_ONE\_COUNT

> **BANK\_TAB\_ONE\_COUNT**: `4171`

***

### BANK\_TAB\_TWO\_COUNT

> **BANK\_TAB\_TWO\_COUNT**: `4172`

***

### BANK\_TAB\_THREE\_COUNT

> **BANK\_TAB\_THREE\_COUNT**: `4173`

***

### BANK\_TAB\_FOUR\_COUNT

> **BANK\_TAB\_FOUR\_COUNT**: `4174`

***

### BANK\_TAB\_FIVE\_COUNT

> **BANK\_TAB\_FIVE\_COUNT**: `4175`

***

### BANK\_TAB\_SIX\_COUNT

> **BANK\_TAB\_SIX\_COUNT**: `4176`

***

### BANK\_TAB\_SEVEN\_COUNT

> **BANK\_TAB\_SEVEN\_COUNT**: `4177`

***

### BANK\_TAB\_EIGHT\_COUNT

> **BANK\_TAB\_EIGHT\_COUNT**: `4178`

***

### BANK\_TAB\_NINE\_COUNT

> **BANK\_TAB\_NINE\_COUNT**: `4179`

***

### DEPOSIT\_BOX\_WITHDRAW\_QUANTITY\_STATE

> **DEPOSIT\_BOX\_WITHDRAW\_QUANTITY\_STATE**: `4430`

## Barrows

### BARROWS\_KILLED\_AHRIM

> **BARROWS\_KILLED\_AHRIM**: `457`

***

### BARROWS\_KILLED\_DHAROK

> **BARROWS\_KILLED\_DHAROK**: `458`

***

### BARROWS\_KILLED\_GUTHAN

> **BARROWS\_KILLED\_GUTHAN**: `459`

***

### BARROWS\_KILLED\_KARIL

> **BARROWS\_KILLED\_KARIL**: `460`

***

### BARROWS\_KILLED\_TORAG

> **BARROWS\_KILLED\_TORAG**: `461`

***

### BARROWS\_KILLED\_VERAC

> **BARROWS\_KILLED\_VERAC**: `462`

***

### BARROWS\_REWARD\_POTENTIAL

> **BARROWS\_REWARD\_POTENTIAL**: `463`

***

### BARROWS\_NPCS\_SLAIN

> **BARROWS\_NPCS\_SLAIN**: `464`

## Blast Furnace

### BAR\_DISPENSER

> **BAR\_DISPENSER**: `936`

These are the expected values:
0 = No bars being processed
1 = Ores are being processed on the conveyor belt, bar dispenser cannot be checked
2 = Bars are cooling down
3 = Bars can be collected

***

### BLAST\_FURNACE\_COPPER\_ORE

> **BLAST\_FURNACE\_COPPER\_ORE**: `959`

***

### BLAST\_FURNACE\_TIN\_ORE

> **BLAST\_FURNACE\_TIN\_ORE**: `950`

***

### BLAST\_FURNACE\_IRON\_ORE

> **BLAST\_FURNACE\_IRON\_ORE**: `951`

***

### BLAST\_FURNACE\_COAL

> **BLAST\_FURNACE\_COAL**: `949`

***

### BLAST\_FURNACE\_MITHRIL\_ORE

> **BLAST\_FURNACE\_MITHRIL\_ORE**: `952`

***

### BLAST\_FURNACE\_ADAMANTITE\_ORE

> **BLAST\_FURNACE\_ADAMANTITE\_ORE**: `953`

***

### BLAST\_FURNACE\_RUNITE\_ORE

> **BLAST\_FURNACE\_RUNITE\_ORE**: `954`

***

### BLAST\_FURNACE\_SILVER\_ORE

> **BLAST\_FURNACE\_SILVER\_ORE**: `956`

***

### BLAST\_FURNACE\_GOLD\_ORE

> **BLAST\_FURNACE\_GOLD\_ORE**: `955`

***

### BLAST\_FURNACE\_BRONZE\_BAR

> **BLAST\_FURNACE\_BRONZE\_BAR**: `941`

***

### BLAST\_FURNACE\_IRON\_BAR

> **BLAST\_FURNACE\_IRON\_BAR**: `942`

***

### BLAST\_FURNACE\_STEEL\_BAR

> **BLAST\_FURNACE\_STEEL\_BAR**: `943`

***

### BLAST\_FURNACE\_MITHRIL\_BAR

> **BLAST\_FURNACE\_MITHRIL\_BAR**: `944`

***

### BLAST\_FURNACE\_ADAMANTITE\_BAR

> **BLAST\_FURNACE\_ADAMANTITE\_BAR**: `945`

***

### BLAST\_FURNACE\_RUNITE\_BAR

> **BLAST\_FURNACE\_RUNITE\_BAR**: `946`

***

### BLAST\_FURNACE\_SILVER\_BAR

> **BLAST\_FURNACE\_SILVER\_BAR**: `948`

***

### BLAST\_FURNACE\_GOLD\_BAR

> **BLAST\_FURNACE\_GOLD\_BAR**: `947`

***

### BLAST\_FURNACE\_COFFER

> **BLAST\_FURNACE\_COFFER**: `5357`

## Blast Mine

### BLAST\_MINE\_COAL

> **BLAST\_MINE\_COAL**: `10698`

***

### BLAST\_MINE\_GOLD

> **BLAST\_MINE\_GOLD**: `10699`

***

### BLAST\_MINE\_MITHRIL

> **BLAST\_MINE\_MITHRIL**: `10700`

***

### BLAST\_MINE\_ADAMANTITE

> **BLAST\_MINE\_ADAMANTITE**: `10701`

***

### BLAST\_MINE\_RUNITE

> **BLAST\_MINE\_RUNITE**: `10702`

## Boss Health Info

### BOSS\_HEALTH\_OVERLAY

> **BOSS\_HEALTH\_OVERLAY**: `12389`

Show boss health overlay setting
0 = on
1 = off

***

### BOSS\_HEALTH\_CURRENT

> **BOSS\_HEALTH\_CURRENT**: `6099`

***

### BOSS\_HEALTH\_MAXIMUM

> **BOSS\_HEALTH\_MAXIMUM**: `6100`

## Combat Achievements

### COMBAT\_ACHIEVEMENTS\_POPUP

> **COMBAT\_ACHIEVEMENTS\_POPUP**: `12455`

Combat Achievements popup settings whenever a new task is completed
0 = popup notification enabled
1 = popup notification disabled

***

### COMBAT\_ACHIEVEMENT\_TIER\_EASY

> **COMBAT\_ACHIEVEMENT\_TIER\_EASY**: `12863`

2 = completed

***

### COMBAT\_ACHIEVEMENT\_TIER\_MEDIUM

> **COMBAT\_ACHIEVEMENT\_TIER\_MEDIUM**: `12864`

2 = completed

***

### COMBAT\_ACHIEVEMENT\_TIER\_HARD

> **COMBAT\_ACHIEVEMENT\_TIER\_HARD**: `12865`

2 = completed

***

### COMBAT\_ACHIEVEMENT\_TIER\_ELITE

> **COMBAT\_ACHIEVEMENT\_TIER\_ELITE**: `12866`

2 = completed

***

### COMBAT\_ACHIEVEMENT\_TIER\_MASTER

> **COMBAT\_ACHIEVEMENT\_TIER\_MASTER**: `12867`

2 = completed

***

### COMBAT\_ACHIEVEMENT\_TIER\_GRANDMASTER

> **COMBAT\_ACHIEVEMENT\_TIER\_GRANDMASTER**: `12868`

2 = completed

## Combat Tasks

### COMBAT\_TASK\_EASY

> **COMBAT\_TASK\_EASY**: `12885`

***

### COMBAT\_TASK\_MEDIUM

> **COMBAT\_TASK\_MEDIUM**: `12886`

***

### COMBAT\_TASK\_HARD

> **COMBAT\_TASK\_HARD**: `12887`

***

### COMBAT\_TASK\_ELITE

> **COMBAT\_TASK\_ELITE**: `12888`

***

### COMBAT\_TASK\_MASTER

> **COMBAT\_TASK\_MASTER**: `12889`

***

### COMBAT\_TASK\_GRANDMASTER

> **COMBAT\_TASK\_GRANDMASTER**: `12890`

## Daily Tasks

### DAILY\_HERB\_BOXES\_COLLECTED

> **DAILY\_HERB\_BOXES\_COLLECTED**: `3961`

***

### DAILY\_STAVES\_COLLECTED

> **DAILY\_STAVES\_COLLECTED**: `4539`

***

### DAILY\_ESSENCE\_COLLECTED

> **DAILY\_ESSENCE\_COLLECTED**: `4547`

***

### DAILY\_RUNES\_COLLECTED

> **DAILY\_RUNES\_COLLECTED**: `4540`

***

### DAILY\_SAND\_COLLECTED

> **DAILY\_SAND\_COLLECTED**: `4549`

***

### DAILY\_FLAX\_STATE

> **DAILY\_FLAX\_STATE**: `4559`

***

### DAILY\_ARROWS\_STATE

> **DAILY\_ARROWS\_STATE**: `4563`

***

### DAILY\_BONEMEAL\_STATE

> **DAILY\_BONEMEAL\_STATE**: `4543`

This varbit tracks how much bonemeal has been redeemed from Robin
The player gets 13 for each diary completed above and including Medium, for a maxiumum of 39

***

### DAILY\_DYNAMITE\_COLLECTED

> **DAILY\_DYNAMITE\_COLLECTED**: `7939`

## Diary Entries

### DIARY\_ARDOUGNE\_EASY

> **DIARY\_ARDOUGNE\_EASY**: `4458`

***

### DIARY\_ARDOUGNE\_MEDIUM

> **DIARY\_ARDOUGNE\_MEDIUM**: `4459`

***

### DIARY\_ARDOUGNE\_HARD

> **DIARY\_ARDOUGNE\_HARD**: `4460`

***

### DIARY\_ARDOUGNE\_ELITE

> **DIARY\_ARDOUGNE\_ELITE**: `4461`

***

### DIARY\_DESERT\_EASY

> **DIARY\_DESERT\_EASY**: `4483`

***

### DIARY\_DESERT\_MEDIUM

> **DIARY\_DESERT\_MEDIUM**: `4484`

***

### DIARY\_DESERT\_HARD

> **DIARY\_DESERT\_HARD**: `4485`

***

### DIARY\_DESERT\_ELITE

> **DIARY\_DESERT\_ELITE**: `4486`

***

### DIARY\_FALADOR\_EASY

> **DIARY\_FALADOR\_EASY**: `4462`

***

### DIARY\_FALADOR\_MEDIUM

> **DIARY\_FALADOR\_MEDIUM**: `4463`

***

### DIARY\_FALADOR\_HARD

> **DIARY\_FALADOR\_HARD**: `4464`

***

### DIARY\_FALADOR\_ELITE

> **DIARY\_FALADOR\_ELITE**: `4465`

***

### DIARY\_FREMENNIK\_EASY

> **DIARY\_FREMENNIK\_EASY**: `4491`

***

### DIARY\_FREMENNIK\_MEDIUM

> **DIARY\_FREMENNIK\_MEDIUM**: `4492`

***

### DIARY\_FREMENNIK\_HARD

> **DIARY\_FREMENNIK\_HARD**: `4493`

***

### DIARY\_FREMENNIK\_ELITE

> **DIARY\_FREMENNIK\_ELITE**: `4494`

***

### DIARY\_KANDARIN\_EASY

> **DIARY\_KANDARIN\_EASY**: `4475`

***

### DIARY\_KANDARIN\_MEDIUM

> **DIARY\_KANDARIN\_MEDIUM**: `4476`

***

### DIARY\_KANDARIN\_HARD

> **DIARY\_KANDARIN\_HARD**: `4477`

***

### DIARY\_KANDARIN\_ELITE

> **DIARY\_KANDARIN\_ELITE**: `4478`

***

### DIARY\_KARAMJA\_EASY

> **DIARY\_KARAMJA\_EASY**: `3578`

***

### DIARY\_KARAMJA\_MEDIUM

> **DIARY\_KARAMJA\_MEDIUM**: `3599`

***

### DIARY\_KARAMJA\_HARD

> **DIARY\_KARAMJA\_HARD**: `3611`

***

### DIARY\_KARAMJA\_ELITE

> **DIARY\_KARAMJA\_ELITE**: `4566`

***

### DIARY\_KOUREND\_EASY

> **DIARY\_KOUREND\_EASY**: `7925`

***

### DIARY\_KOUREND\_MEDIUM

> **DIARY\_KOUREND\_MEDIUM**: `7926`

***

### DIARY\_KOUREND\_HARD

> **DIARY\_KOUREND\_HARD**: `7927`

***

### DIARY\_KOUREND\_ELITE

> **DIARY\_KOUREND\_ELITE**: `7928`

***

### DIARY\_LUMBRIDGE\_EASY

> **DIARY\_LUMBRIDGE\_EASY**: `4495`

***

### DIARY\_LUMBRIDGE\_MEDIUM

> **DIARY\_LUMBRIDGE\_MEDIUM**: `4496`

***

### DIARY\_LUMBRIDGE\_HARD

> **DIARY\_LUMBRIDGE\_HARD**: `4497`

***

### DIARY\_LUMBRIDGE\_ELITE

> **DIARY\_LUMBRIDGE\_ELITE**: `4498`

***

### DIARY\_MORYTANIA\_EASY

> **DIARY\_MORYTANIA\_EASY**: `4487`

***

### DIARY\_MORYTANIA\_MEDIUM

> **DIARY\_MORYTANIA\_MEDIUM**: `4488`

***

### DIARY\_MORYTANIA\_HARD

> **DIARY\_MORYTANIA\_HARD**: `4489`

***

### DIARY\_MORYTANIA\_ELITE

> **DIARY\_MORYTANIA\_ELITE**: `4490`

***

### DIARY\_VARROCK\_EASY

> **DIARY\_VARROCK\_EASY**: `4479`

***

### DIARY\_VARROCK\_MEDIUM

> **DIARY\_VARROCK\_MEDIUM**: `4480`

***

### DIARY\_VARROCK\_HARD

> **DIARY\_VARROCK\_HARD**: `4481`

***

### DIARY\_VARROCK\_ELITE

> **DIARY\_VARROCK\_ELITE**: `4482`

***

### DIARY\_WESTERN\_EASY

> **DIARY\_WESTERN\_EASY**: `4471`

***

### DIARY\_WESTERN\_MEDIUM

> **DIARY\_WESTERN\_MEDIUM**: `4472`

***

### DIARY\_WESTERN\_HARD

> **DIARY\_WESTERN\_HARD**: `4473`

***

### DIARY\_WESTERN\_ELITE

> **DIARY\_WESTERN\_ELITE**: `4474`

***

### DIARY\_WILDERNESS\_EASY

> **DIARY\_WILDERNESS\_EASY**: `4466`

***

### DIARY\_WILDERNESS\_MEDIUM

> **DIARY\_WILDERNESS\_MEDIUM**: `4467`

***

### DIARY\_WILDERNESS\_HARD

> **DIARY\_WILDERNESS\_HARD**: `4468`

***

### DIARY\_WILDERNESS\_ELITE

> **DIARY\_WILDERNESS\_ELITE**: `4469`

## Divine Effect Timers

### DIVINE\_SUPER\_ATTACK

> **DIVINE\_SUPER\_ATTACK**: `8429`

Number of game ticks remaining on a divine effect.
A potion that combines multiple effects will set the varbits for the individual effects as well as its own effect.

***

### DIVINE\_SUPER\_STRENGTH

> **DIVINE\_SUPER\_STRENGTH**: `8430`

***

### DIVINE\_SUPER\_DEFENCE

> **DIVINE\_SUPER\_DEFENCE**: `8431`

***

### DIVINE\_RANGING

> **DIVINE\_RANGING**: `8432`

***

### DIVINE\_MAGIC

> **DIVINE\_MAGIC**: `8433`

***

### DIVINE\_SUPER\_COMBAT

> **DIVINE\_SUPER\_COMBAT**: `13663`

***

### DIVINE\_BASTION

> **DIVINE\_BASTION**: `13664`

***

### DIVINE\_BATTLEMAGE

> **DIVINE\_BATTLEMAGE**: `13665`

## Drift Net Catch Count

### NORTH\_NET\_CATCH\_COUNT

> **NORTH\_NET\_CATCH\_COUNT**: `5813`

***

### SOUTH\_NET\_CATCH\_COUNT

> **SOUTH\_NET\_CATCH\_COUNT**: `5815`

## Enumeration Members

### TRANSPARENT\_CHATBOX

> **TRANSPARENT\_CHATBOX**: `4608`

***

### RUN\_SLOWED\_DEPLETION\_ACTIVE

> **RUN\_SLOWED\_DEPLETION\_ACTIVE**: `25`

***

### STAMINA\_EFFECT

> **STAMINA\_EFFECT**: `24`

Stamina effect timer
Number of game ticks remaining on stamina effect in intervals of 10, for a value X there are 10 * X game ticks remaining.
The stamina effect expires once this reaches 0.

***

### ANTIFIRE

> **ANTIFIRE**: `3981`

Antifire timer
Number of game ticks remaining on antifire in intervals of 30, for a value X there are 30 * X game ticks remaining.
The antifire expires once this reaches 0.

***

### SUPER\_ANTIFIRE

> **SUPER\_ANTIFIRE**: `6101`

Super Antifire timer
Number of game ticks remaining on super antifire in intervals of 20, for a value X there are 20 * X game ticks remaining.
The super antifire expires once this reaches 0.

***

### MAGIC\_IMBUE

> **MAGIC\_IMBUE**: `5438`

Magic imbue timer
Number of game ticks remaining on magic imbue effect in intervals of 10, for a value X there are 10 * X game ticks remaining.
The magic imbue effect expires once this reaches 0.

***

### MOONLIGHT\_POTION

> **MOONLIGHT\_POTION**: `10029`

Moonlight potion timer.
When at least 70 herblore, the moonlight potion's defense effect will be removed when this timer runs out.
If the player drinks a dose of moonlight potion while already under its effects, desync between
Varbits.MOONLIGHT_POTION and Varbits.DIVINE_SUPER_DEFENCE can occur, with the latter being 1 tick greater.
In case of desync, the moonlight defence effect will be removed once Varbits.DIVINE_SUPER_DEFENCE becomes 0.

***

### RING\_OF\_ENDURANCE\_EFFECT

> **RING\_OF\_ENDURANCE\_EFFECT**: `10385`

Ring of endurance effect timer, stamina duration extended from using the ring of endurance
Number of game ticks remaining on ring of endurance effect in intervals of 10, for a value X there are 10 * X game ticks remaining.
Unequipping the ring of endurance will cause this to change to 0.
When this reaches 0, [STAMINA\_EFFECT](#stamina_effect) will begin counting down.

***

### CHAT\_SCROLLBAR\_ON\_LEFT

> **CHAT\_SCROLLBAR\_ON\_LEFT**: `6374`

If scrollbar in resizable mode chat is on the left

***

### EQUIPPED\_WEAPON\_TYPE

> **EQUIPPED\_WEAPON\_TYPE**: `357`

Equipped weapon type

***

### DEFENSIVE\_CASTING\_MODE

> **DEFENSIVE\_CASTING\_MODE**: `2668`

Defensive casting mode

***

### SIDE\_PANELS

> **SIDE\_PANELS**: `4607`

Options

***

### IN\_GAME\_BA

> **IN\_GAME\_BA**: `3923`

Barbarian Assault

***

### BA\_GC

> **BA\_GC**: `4768`

***

### IN\_WILDERNESS

> **IN\_WILDERNESS**: `5963`

0 = Outside wilderness
1 = In wilderness

***

### FISHING\_TRAWLER\_ACTIVITY

> **FISHING\_TRAWLER\_ACTIVITY**: `3377`

Fishing Trawler
FISHING_TRAWLER_ACTIVITY Expected values: 0-255

***

### EXPERIENCE\_DROP\_COLOR

> **EXPERIENCE\_DROP\_COLOR**: `4695`

Experience drop color

***

### NMZ\_POINTS

> **NMZ\_POINTS**: `3949`

***

### MULTICOMBAT\_AREA

> **MULTICOMBAT\_AREA**: `4605`

Multicombat area

***

### QUEST\_THE\_HAND\_IN\_THE\_SAND

> **QUEST\_THE\_HAND\_IN\_THE\_SAND**: `1527`

The Hand in the Sand quest status

***

### QUEST\_DS2

> **QUEST\_DS2**: `6104`

Dragon slayer 2 quest status

***

### AUTOWEED

> **AUTOWEED**: `5557`

Automatically weed farming patches

***

### ACCOUNT\_TYPE

> **ACCOUNT\_TYPE**: `1777`

The player's account type.
0 = normal
1 = ironman
2 = ultimate ironman
3 = hardcore ironman
4 = group ironman
5 = hardcore group ironman
6 = unranked group ironman

***

### OXYGEN\_LEVEL

> **OXYGEN\_LEVEL**: `5811`

The varbit that stores the oxygen percentage for player

***

### NORTH\_NET\_STATUS

> **NORTH\_NET\_STATUS**: `5812`

Drift net status
Expected values
0 = Unset
1 = Set up
2 = Caught some fish
3 = Full

***

### SOUTH\_NET\_STATUS

> **SOUTH\_NET\_STATUS**: `5814`

***

### DRIFT\_NET\_COLLECT

> **DRIFT\_NET\_COLLECT**: `5933`

Drift net collect interface
Expected values:
0 = Not open
1 = North interface open
2 = South interface open

***

### CORP\_DAMAGE

> **CORP\_DAMAGE**: `999`

Corp beast damage

***

### WORLDHOPPER\_FAVORITE\_1

> **WORLDHOPPER\_FAVORITE\_1**: `4597`

***

### WORLDHOPPER\_FAVORITE\_2

> **WORLDHOPPER\_FAVORITE\_2**: `4598`

***

### IMBUED\_HEART\_COOLDOWN

> **IMBUED\_HEART\_COOLDOWN**: `5361`

Imbued Heart cooldown
Number of game tick remaining on cooldown in intervals of 10, for a value X there are 10 * X game ticks remaining.
The heart regains its power once this reaches 0.

***

### DRAGONFIRE\_SHIELD\_COOLDOWN

> **DRAGONFIRE\_SHIELD\_COOLDOWN**: `6539`

Dragonfire shield cooldown
Number of game ticks remaining on cooldown in intervals of 8, for a value X there are 8 * X game ticks remaining.

***

### GE\_OFFER\_CREATION\_TYPE

> **GE\_OFFER\_CREATION\_TYPE**: `4397`

Type of GE offer currently being created
0 = buy
1 = sell

***

### QUEST\_TAB

> **QUEST\_TAB**: `8168`

The active tab within the quest interface

***

### WINTERTODT\_TIMER

> **WINTERTODT\_TIMER**: `7980`

***

### PARASITE

> **PARASITE**: `10151`

Parasite infection status during nightmare of ashihama bossfight
0 = not infected
1 = infected

***

### WIKI\_ENTITY\_LOOKUP

> **WIKI\_ENTITY\_LOOKUP**: `10113`

Whether the vanilla wiki entity lookup is displayed under the minimap
0 = Enabled
1 = Disabled

***

### PVP\_SPEC\_ORB

> **PVP\_SPEC\_ORB**: `8121`

Whether the player is in a PvP area
0 = Player is not in PvP area
1 = Player is in PvP area
Note: The name of this varbit comes from historical behavior where
the special attack orb would be disabled in PvP, but this was changed
on 2023-03-09 due to Poll 78. Yet, the varbit still updates as before.

***

### COLLECTION\_LOG\_NOTIFICATION

> **COLLECTION\_LOG\_NOTIFICATION**: `11959`

Collection Log notification settings whenever a new item is added
0 = no notification
1 = chat notification only
2 = popup notification only
3 = chat and popup

***

### SHOW\_PVP\_KDR\_STATS

> **SHOW\_PVP\_KDR\_STATS**: `4143`

Whether the PVP kill-death stats widget should be drawn while in the wilderness or in PVP worlds.
0 = Disabled
1 = Enabled

***

### TELEBLOCK

> **TELEBLOCK**: `4163`

State of Teleblock spell effects on the player
0 = Teleblock inactive, no immunity
1 &lt,= X &lt,= 100 = Teleblock inactive, remaining ticks of immunity from reapplication of spell effect
101 &lt,= Teleblock active, remaining ticks of blocking effect

***

### GOD\_WARS\_ALTAR\_COOLDOWN

> **GOD\_WARS\_ALTAR\_COOLDOWN**: `4099`

Cooldown timer remaining before eligible to restore at a god wars dungeon altar.
Number of game ticks remaining is in intervals of 100, for a value X there are 100 * X game ticks remaining.
A player can pray at a god wars altar once this reaches 0.

***

### SCURRIUS\_FOOD\_PILE\_COOLDOWN

> **SCURRIUS\_FOOD\_PILE\_COOLDOWN**: `9581`

Cooldown timer remaining before being able to eat from the piles of food in Scurrius's lair.
Number of game ticks remaining is in intervals of 100, for a value X there are 100 * X game ticks remaining.
A player can eat from the food piles once this reaches 0.

***

### FARMERS\_AFFINITY

> **FARMERS\_AFFINITY**: `11765`

Farmer's Affinity effect timer
Number of game ticks remaining on Farmer's Affinity effect in intervals of 20, for a value X there are 20 * X game ticks remaining.
The Farmer's Affinity expires once this reaches 0.

***

### MENAPHITE\_REMEDY

> **MENAPHITE\_REMEDY**: `14448`

If the player has Menaphite remedy effect active.
This will go down by 1 every 25 ticks (15 seconds) and the player's combat stats will be restored by 6 + 16%.
Set to 20 upon consuming potion.

***

### BUFF\_STAT\_BOOST

> **BUFF\_STAT\_BOOST**: `14344`

How many salt stat boost refreshes the player has remaining.
This will go down by 1 every 25 ticks (15 seconds) and the player's stats will be restored.
Set to 32 upon crushing salts.

***

### LIQUID\_ADERNALINE\_ACTIVE

> **LIQUID\_ADERNALINE\_ACTIVE**: `14361`

If the player has liquid adrenaline buff active
0 = inactive
1 = active

***

### NMZ\_OVERLOAD\_REFRESHES\_REMAINING

> **NMZ\_OVERLOAD\_REFRESHES\_REMAINING**: `3955`

How many NMZ overload refreshes the player has remaining.
This will go down by 1 every 25 ticks (15 seconds) and the player's stats will be restored.
Set to 20 upon drinking an overload.

***

### COX\_OVERLOAD\_REFRESHES\_REMAINING

> **COX\_OVERLOAD\_REFRESHES\_REMAINING**: `5418`

How many Chambers of Xeric overload refreshes the player has remaining.
This will go down by 1 every 25 ticks (15 seconds) and the player's stats will be restored.
Set to 20 upon drinking an overload.

***

### DISABLE\_LEVEL\_UP\_INTERFACE

> **DISABLE\_LEVEL\_UP\_INTERFACE**: `9452`

Whether the level up interface is disabled

***

### PRAYERBOOK

> **PRAYERBOOK**: `14826`

***

### VIGGORA\_LOCATION

> **VIGGORA\_LOCATION**: `815`

During and after Curse of the Empty Lord, Viggora can be located in one of three locations,
which is uniquely and permanently set for each player.
This varbit determines which location he will appear in, which is useful for a master clue step.

***

### CURSE\_OF\_THE\_MOONS

> **CURSE\_OF\_THE\_MOONS**: `9853`

The amount of Curse of the Moons stacks received when fighting the Blue Moon or Eclipse Moon.
The varbit value remains 0 when fighting the Blood Moon.
When fighting the Blue Moon, the player's joints will lock up at 18 stacks, which causes their next attack to be
canceled and 18 stacks to be removed.
When fighting the Eclipse Moon, the stacks increase the chance of a player's attack glancing off the shield of
the Eclipse Moon. Glancing attacks reduce the player's max hit by two times the flat armour of the Eclipse Moon.

***

### COLOSSEUM\_DOOM

> **COLOSSEUM\_DOOM**: `9801`

The amount of Doom stacks received in the Fortis Colosseum.

***

### BUFF\_GOADING\_POTION

> **BUFF\_GOADING\_POTION**: `11294`

***

### BUFF\_PRAYER\_REGENERATION

> **BUFF\_PRAYER\_REGENERATION**: `11361`

***

### COLOSSAL\_WYRM\_COURSE\_BASIC

> **COLOSSAL\_WYRM\_COURSE\_BASIC**: `11292`

The player's progress value for the colossal wyrm advanced basic course.
Max value = 6,
</p>

***

### COLOSSAL\_WYRM\_COURSE\_ADVANCED

> **COLOSSAL\_WYRM\_COURSE\_ADVANCED**: `11293`

The player's progress value for the colossal wyrm advanced agility course.
Max value = 6,
</p>

***

### WINTERTODT\_WARMTH

> **WINTERTODT\_WARMTH**: `11434`

***

### JARVIS\_GRAVESTONE

> **JARVIS\_GRAVESTONE**: `6008`

The state of Jarvis' gravestone.
0, 2, 3 = Bush (eg. saved Jarvis, or did not partake in the 2017 Halloween event)
1 = Gravestone

## Essence Pouch

### ESSENCE\_POUCH\_SMALL\_AMOUNT

> **ESSENCE\_POUCH\_SMALL\_AMOUNT**: `603`

***

### ESSENCE\_POUCH\_MEDIUM\_AMOUNT

> **ESSENCE\_POUCH\_MEDIUM\_AMOUNT**: `604`

***

### ESSENCE\_POUCH\_LARGE\_AMOUNT

> **ESSENCE\_POUCH\_LARGE\_AMOUNT**: `605`

***

### ESSENCE\_POUCH\_GIANT\_AMOUNT

> **ESSENCE\_POUCH\_GIANT\_AMOUNT**: `606`

***

### ESSENCE\_POUCH\_COLOSSAL\_AMOUNT

> **ESSENCE\_POUCH\_COLOSSAL\_AMOUNT**: `13682`

***

### ESSENCE\_POUCH\_COLOSSAL\_DEGRADE

> **ESSENCE\_POUCH\_COLOSSAL\_DEGRADE**: `13683`

## Experience Tracker

### EXPERIENCE\_TRACKER\_POSITION

> **EXPERIENCE\_TRACKER\_POSITION**: `4692`

EXPERIENCE_TRACKER_POSITION expected values:
0 = Right
1 = Middle
2 = Left

***

### EXPERIENCE\_TRACKER\_COUNTER

> **EXPERIENCE\_TRACKER\_COUNTER**: `4697`

***

### EXPERIENCE\_TRACKER\_PROGRESS\_BAR

> **EXPERIENCE\_TRACKER\_PROGRESS\_BAR**: `4698`

## Explorer Ring

### EXPLORER\_RING\_ALCHTYPE

> **EXPLORER\_RING\_ALCHTYPE**: `5398`

***

### EXPLORER\_RING\_TELEPORTS

> **EXPLORER\_RING\_TELEPORTS**: `4552`

***

### EXPLORER\_RING\_ALCHS

> **EXPLORER\_RING\_ALCHS**: `4554`

***

### EXPLORER\_RING\_RUNENERGY

> **EXPLORER\_RING\_RUNENERGY**: `4553`

## Fairy Ring

### FAIR\_RING\_LAST\_DESTINATION

> **FAIR\_RING\_LAST\_DESTINATION**: `5374`

***

### FAIRY\_RING\_DIAL\_ADCB

> **FAIRY\_RING\_DIAL\_ADCB**: `3985`

Left Dial

***

### FAIRY\_RIGH\_DIAL\_ILJK

> **FAIRY\_RIGH\_DIAL\_ILJK**: `3986`

Middle Dial

***

### FAIRY\_RING\_DIAL\_PSRQ

> **FAIRY\_RING\_DIAL\_PSRQ**: `3987`

Right Dial

## Herbiboar

### HB\_STARTED

> **HB\_STARTED**: `5767`

Started hunting Herbiboar.
NOTE: This value remains at 0 even after starting a Herbiboar trail up until searching the first object along the
hunting path.

***

### HB\_TRAIL\_31303

> **HB\_TRAIL\_31303**: `5737`

***

### HB\_TRAIL\_31306

> **HB\_TRAIL\_31306**: `5738`

***

### HB\_TRAIL\_31309

> **HB\_TRAIL\_31309**: `5739`

***

### HB\_TRAIL\_31312

> **HB\_TRAIL\_31312**: `5740`

***

### HB\_TRAIL\_31315

> **HB\_TRAIL\_31315**: `5741`

***

### HB\_TRAIL\_31318

> **HB\_TRAIL\_31318**: `5742`

***

### HB\_TRAIL\_31321

> **HB\_TRAIL\_31321**: `5743`

***

### HB\_TRAIL\_31324

> **HB\_TRAIL\_31324**: `5744`

***

### HB\_TRAIL\_31327

> **HB\_TRAIL\_31327**: `5745`

***

### HB\_TRAIL\_31330

> **HB\_TRAIL\_31330**: `5746`

***

### HB\_TRAIL\_31333

> **HB\_TRAIL\_31333**: `5768`

***

### HB\_TRAIL\_31336

> **HB\_TRAIL\_31336**: `5769`

***

### HB\_TRAIL\_31339

> **HB\_TRAIL\_31339**: `5770`

***

### HB\_TRAIL\_31342

> **HB\_TRAIL\_31342**: `5771`

***

### HB\_TRAIL\_31345

> **HB\_TRAIL\_31345**: `5772`

***

### HB\_TRAIL\_31348

> **HB\_TRAIL\_31348**: `5773`

***

### HB\_TRAIL\_31351

> **HB\_TRAIL\_31351**: `5774`

***

### HB\_TRAIL\_31354

> **HB\_TRAIL\_31354**: `5775`

***

### HB\_TRAIL\_31357

> **HB\_TRAIL\_31357**: `5776`

***

### HB\_TRAIL\_31360

> **HB\_TRAIL\_31360**: `5777`

***

### HB\_TRAIL\_31363

> **HB\_TRAIL\_31363**: `5747`

***

### HB\_TRAIL\_31366

> **HB\_TRAIL\_31366**: `5748`

***

### HB\_TRAIL\_31369

> **HB\_TRAIL\_31369**: `5749`

***

### HB\_TRAIL\_31372

> **HB\_TRAIL\_31372**: `5750`

***

### HB\_FINISH

> **HB\_FINISH**: `5766`

## Kingdom of Miscellania Management

### KINGDOM\_APPROVAL

> **KINGDOM\_APPROVAL**: `72`

Kingdom Approval is represented as a 7-bit unsigned integer, 127 corresponds to 100% approval

***

### KINGDOM\_COFFER

> **KINGDOM\_COFFER**: `74`

## Kourend House Favours

### KOUREND\_FAVOR\_ARCEUUS

> **KOUREND\_FAVOR\_ARCEUUS**: `4896`

***

### KOUREND\_FAVOR\_HOSIDIUS

> **KOUREND\_FAVOR\_HOSIDIUS**: `4895`

***

### KOUREND\_FAVOR\_LOVAKENGJ

> **KOUREND\_FAVOR\_LOVAKENGJ**: `4898`

***

### KOUREND\_FAVOR\_PISCARILIUS

> **KOUREND\_FAVOR\_PISCARILIUS**: `4899`

***

### KOUREND\_FAVOR\_SHAYZIEN

> **KOUREND\_FAVOR\_SHAYZIEN**: `4894`

## League Relics

### LEAGUE\_RELIC\_1

> **LEAGUE\_RELIC\_1**: `10049`

***

### LEAGUE\_RELIC\_2

> **LEAGUE\_RELIC\_2**: `10050`

***

### LEAGUE\_RELIC\_3

> **LEAGUE\_RELIC\_3**: `10051`

***

### LEAGUE\_RELIC\_4

> **LEAGUE\_RELIC\_4**: `10052`

***

### LEAGUE\_RELIC\_5

> **LEAGUE\_RELIC\_5**: `10053`

***

### LEAGUE\_RELIC\_6

> **LEAGUE\_RELIC\_6**: `11696`

***

### LEAGUE\_RELIC\_7

> **LEAGUE\_RELIC\_7**: `17301`

***

### LEAGUE\_RELIC\_8

> **LEAGUE\_RELIC\_8**: `17302`

## Leagues Combat Mastery

### LEAGUES\_MELEE\_COMBAT\_MASTERY\_LEVEL

> **LEAGUES\_MELEE\_COMBAT\_MASTERY\_LEVEL**: `11580`

***

### LEAGUES\_RANGED\_COMBAT\_MASTERY\_LEVEL

> **LEAGUES\_RANGED\_COMBAT\_MASTERY\_LEVEL**: `11581`

***

### LEAGUES\_MAGIC\_COMBAT\_MASTERY\_LEVEL

> **LEAGUES\_MAGIC\_COMBAT\_MASTERY\_LEVEL**: `11582`

## Making Friends with My Arm - Fire Pits

### FIRE\_PIT\_GIANT\_MOLE

> **FIRE\_PIT\_GIANT\_MOLE**: `6532`

Expected values:
0 = Not built
1 = Built

***

### FIRE\_PIT\_LUMBRIDGE\_SWAMP

> **FIRE\_PIT\_LUMBRIDGE\_SWAMP**: `6533`

***

### FIRE\_PIT\_MOS\_LE\_HARMLESS

> **FIRE\_PIT\_MOS\_LE\_HARMLESS**: `6534`

## Motherlode Mine

### SACK\_NUMBER

> **SACK\_NUMBER**: `5558`

***

### SACK\_UPGRADED

> **SACK\_UPGRADED**: `5556`

## Muted Volume Restore Values

### MUTED\_MUSIC\_VOLUME

> **MUTED\_MUSIC\_VOLUME**: `12426`

***

### MUTED\_SOUND\_EFFECT\_VOLUME

> **MUTED\_SOUND\_EFFECT\_VOLUME**: `12427`

***

### MUTED\_AREA\_EFFECT\_VOLUME

> **MUTED\_AREA\_EFFECT\_VOLUME**: `12428`

## Nightmare Zone

### NMZ\_ABSORPTION

> **NMZ\_ABSORPTION**: `3956`

## Prayers

### QUICK\_PRAYER

> **QUICK\_PRAYER**: `4103`

***

### PRAYER\_THICK\_SKIN

> **PRAYER\_THICK\_SKIN**: `4104`

***

### PRAYER\_BURST\_OF\_STRENGTH

> **PRAYER\_BURST\_OF\_STRENGTH**: `4105`

***

### PRAYER\_CLARITY\_OF\_THOUGHT

> **PRAYER\_CLARITY\_OF\_THOUGHT**: `4106`

***

### PRAYER\_SHARP\_EYE

> **PRAYER\_SHARP\_EYE**: `4122`

***

### PRAYER\_MYSTIC\_WILL

> **PRAYER\_MYSTIC\_WILL**: `4123`

***

### PRAYER\_ROCK\_SKIN

> **PRAYER\_ROCK\_SKIN**: `4107`

***

### PRAYER\_SUPERHUMAN\_STRENGTH

> **PRAYER\_SUPERHUMAN\_STRENGTH**: `4108`

***

### PRAYER\_IMPROVED\_REFLEXES

> **PRAYER\_IMPROVED\_REFLEXES**: `4109`

***

### PRAYER\_RAPID\_RESTORE

> **PRAYER\_RAPID\_RESTORE**: `4110`

***

### PRAYER\_RAPID\_HEAL

> **PRAYER\_RAPID\_HEAL**: `4111`

***

### PRAYER\_PROTECT\_ITEM

> **PRAYER\_PROTECT\_ITEM**: `4112`

***

### PRAYER\_HAWK\_EYE

> **PRAYER\_HAWK\_EYE**: `4124`

***

### PRAYER\_MYSTIC\_LORE

> **PRAYER\_MYSTIC\_LORE**: `4125`

***

### PRAYER\_STEEL\_SKIN

> **PRAYER\_STEEL\_SKIN**: `4113`

***

### PRAYER\_ULTIMATE\_STRENGTH

> **PRAYER\_ULTIMATE\_STRENGTH**: `4114`

***

### PRAYER\_INCREDIBLE\_REFLEXES

> **PRAYER\_INCREDIBLE\_REFLEXES**: `4115`

***

### PRAYER\_PROTECT\_FROM\_MAGIC

> **PRAYER\_PROTECT\_FROM\_MAGIC**: `4116`

***

### PRAYER\_PROTECT\_FROM\_MISSILES

> **PRAYER\_PROTECT\_FROM\_MISSILES**: `4117`

***

### PRAYER\_PROTECT\_FROM\_MELEE

> **PRAYER\_PROTECT\_FROM\_MELEE**: `4118`

***

### PRAYER\_EAGLE\_EYE

> **PRAYER\_EAGLE\_EYE**: `4126`

***

### PRAYER\_MYSTIC\_MIGHT

> **PRAYER\_MYSTIC\_MIGHT**: `4127`

***

### PRAYER\_RETRIBUTION

> **PRAYER\_RETRIBUTION**: `4119`

***

### PRAYER\_REDEMPTION

> **PRAYER\_REDEMPTION**: `4120`

***

### PRAYER\_SMITE

> **PRAYER\_SMITE**: `4121`

***

### PRAYER\_CHIVALRY

> **PRAYER\_CHIVALRY**: `4128`

***

### PRAYER\_PIETY

> **PRAYER\_PIETY**: `4129`

***

### PRAYER\_PRESERVE

> **PRAYER\_PRESERVE**: `5466`

***

### PRAYER\_RIGOUR

> **PRAYER\_RIGOUR**: `5464`

***

### PRAYER\_AUGURY

> **PRAYER\_AUGURY**: `5465`

***

### PRAYER\_DEADEYE\_UNLOCKED

> **PRAYER\_DEADEYE\_UNLOCKED**: `16097`

***

### PRAYER\_MYSTIC\_VIGOUR\_UNLOCKED

> **PRAYER\_MYSTIC\_VIGOUR\_UNLOCKED**: `16098`

## Pyramid Plunder

### PYRAMID\_PLUNDER\_ROOM\_LOCATION

> **PYRAMID\_PLUNDER\_ROOM\_LOCATION**: `2365`

***

### PYRAMID\_PLUNDER\_TIMER

> **PYRAMID\_PLUNDER\_TIMER**: `2375`

***

### PYRAMID\_PLUNDER\_THIEVING\_LEVEL

> **PYRAMID\_PLUNDER\_THIEVING\_LEVEL**: `2376`

***

### PYRAMID\_PLUNDER\_ROOM

> **PYRAMID\_PLUNDER\_ROOM**: `2377`

## Raids

### IN\_RAID

> **IN\_RAID**: `5432`

***

### TOTAL\_POINTS

> **TOTAL\_POINTS**: `5431`

***

### RAID\_STATE

> **RAID\_STATE**: `5425`

0 = raid not started, >0 = raid started

## Ruinous Powers

### PRAYER\_RP\_REJUVENATION

> **PRAYER\_RP\_REJUVENATION**: `14840`

***

### PRAYER\_RP\_ANCIENT\_STRENGTH

> **PRAYER\_RP\_ANCIENT\_STRENGTH**: `14829`

***

### PRAYER\_RP\_ANCIENT\_SIGHT

> **PRAYER\_RP\_ANCIENT\_SIGHT**: `14830`

***

### PRAYER\_RP\_ANCIENT\_WILL

> **PRAYER\_RP\_ANCIENT\_WILL**: `14831`

***

### PRAYER\_RP\_PROTECT\_ITEM

> **PRAYER\_RP\_PROTECT\_ITEM**: `14966`

***

### PRAYER\_RP\_RUINOUS\_GRACE

> **PRAYER\_RP\_RUINOUS\_GRACE**: `14841`

***

### PRAYER\_RP\_DAMPEN\_MAGIC

> **PRAYER\_RP\_DAMPEN\_MAGIC**: `14964`

***

### PRAYER\_RP\_DAMPEN\_RANGED

> **PRAYER\_RP\_DAMPEN\_RANGED**: `14963`

***

### PRAYER\_RP\_DAMPEN\_MELEE

> **PRAYER\_RP\_DAMPEN\_MELEE**: `14962`

***

### PRAYER\_RP\_TRINITAS

> **PRAYER\_RP\_TRINITAS**: `14832`

***

### PRAYER\_RP\_BERSERKER

> **PRAYER\_RP\_BERSERKER**: `14844`

***

### PRAYER\_RP\_PURGE

> **PRAYER\_RP\_PURGE**: `14839`

***

### PRAYER\_RP\_METABOLISE

> **PRAYER\_RP\_METABOLISE**: `14843`

***

### PRAYER\_RP\_REBUKE

> **PRAYER\_RP\_REBUKE**: `14850`

***

### PRAYER\_RP\_VINDICATION

> **PRAYER\_RP\_VINDICATION**: `14851`

***

### PRAYER\_RP\_DECIMATE

> **PRAYER\_RP\_DECIMATE**: `14833`

***

### PRAYER\_RP\_ANNIHILATE

> **PRAYER\_RP\_ANNIHILATE**: `14834`

***

### PRAYER\_RP\_VAPORISE

> **PRAYER\_RP\_VAPORISE**: `14835`

***

### PRAYER\_RP\_FUMUS\_VOW

> **PRAYER\_RP\_FUMUS\_VOW**: `14845`

***

### PRAYER\_RP\_UMBRA\_VOW

> **PRAYER\_RP\_UMBRA\_VOW**: `14847`

***

### PRAYER\_RP\_CRUORS\_VOW

> **PRAYER\_RP\_CRUORS\_VOW**: `14846`

***

### PRAYER\_RP\_GLACIES\_VOW

> **PRAYER\_RP\_GLACIES\_VOW**: `14848`

***

### PRAYER\_RP\_WRATH

> **PRAYER\_RP\_WRATH**: `14842`

***

### PRAYER\_RP\_INTENSIFY

> **PRAYER\_RP\_INTENSIFY**: `14965`

## Runepouch

### RUNE\_POUCH\_RUNE1

> **RUNE\_POUCH\_RUNE1**: `29`

***

### RUNE\_POUCH\_RUNE2

> **RUNE\_POUCH\_RUNE2**: `1622`

***

### RUNE\_POUCH\_RUNE3

> **RUNE\_POUCH\_RUNE3**: `1623`

***

### RUNE\_POUCH\_RUNE4

> **RUNE\_POUCH\_RUNE4**: `14285`

***

### RUNE\_POUCH\_RUNE5

> **RUNE\_POUCH\_RUNE5**: `15373`

***

### RUNE\_POUCH\_RUNE6

> **RUNE\_POUCH\_RUNE6**: `15374`

***

### RUNE\_POUCH\_AMOUNT1

> **RUNE\_POUCH\_AMOUNT1**: `1624`

***

### RUNE\_POUCH\_AMOUNT2

> **RUNE\_POUCH\_AMOUNT2**: `1625`

***

### RUNE\_POUCH\_AMOUNT3

> **RUNE\_POUCH\_AMOUNT3**: `1626`

***

### RUNE\_POUCH\_AMOUNT4

> **RUNE\_POUCH\_AMOUNT4**: `14286`

***

### RUNE\_POUCH\_AMOUNT5

> **RUNE\_POUCH\_AMOUNT5**: `15375`

***

### RUNE\_POUCH\_AMOUNT6

> **RUNE\_POUCH\_AMOUNT6**: `15376`

## Slayer

### SLAYER\_POINTS

> **SLAYER\_POINTS**: `4068`

***

### SLAYER\_TASK\_STREAK

> **SLAYER\_TASK\_STREAK**: `4069`

***

### SLAYER\_TASK\_BOSS

> **SLAYER\_TASK\_BOSS**: `4723`

The assigned boss for boss slayer.

***

### BURTHORPE\_SLAYER\_MASTER

> **BURTHORPE\_SLAYER\_MASTER**: `10782`

The slayer master which is present at Burthorpe.
0 = Turael
1, 2 = Aya
3 = Null

## Special

### AGILITY\_PORTAL\_ID

> **AGILITY\_PORTAL\_ID**: `9298`

***

### TEMPOROSS\_IS\_TETHERED

> **TEMPOROSS\_IS\_TETHERED**: `11895`

***

### TEMPOROSS\_REWARD\_POOL\_NUMBER

> **TEMPOROSS\_REWARD\_POOL\_NUMBER**: `11936`

***

### UNKNOWN\_ONE

> **UNKNOWN\_ONE**: `327`

***

### UNKNOWN\_TWO

> **UNKNOWN\_TWO**: `5006`

***

### GAUNTLET\_ACTIVE

> **GAUNTLET\_ACTIVE**: `9177`

***

### CORRUPTED\_GAUNTLET\_ACTIVE

> **CORRUPTED\_GAUNTLET\_ACTIVE**: `9178`

## Spell Active States

### VENGEANCE\_ACTIVE

> **VENGEANCE\_ACTIVE**: `2450`

***

### DEATH\_CHARGE

> **DEATH\_CHARGE**: `12411`

***

### RESURRECT\_THRALL

> **RESURRECT\_THRALL**: `12413`

***

### SHADOW\_VEIL

> **SHADOW\_VEIL**: `12414`

## Spell Cooldowns

### HEAL\_GROUP\_COOLDOWN

> **HEAL\_GROUP\_COOLDOWN**: `925`

***

### VENGEANCE\_COOLDOWN

> **VENGEANCE\_COOLDOWN**: `2451`

***

### DEATH\_CHARGE\_COOLDOWN

> **DEATH\_CHARGE\_COOLDOWN**: `12138`

***

### CORRUPTION\_COOLDOWN

> **CORRUPTION\_COOLDOWN**: `12288`

***

### RESURRECT\_THRALL\_COOLDOWN

> **RESURRECT\_THRALL\_COOLDOWN**: `12290`

***

### SHADOW\_VEIL\_COOLDOWN

> **SHADOW\_VEIL\_COOLDOWN**: `12291`

***

### WARD\_OF\_ARCEUUS\_COOLDOWN

> **WARD\_OF\_ARCEUUS\_COOLDOWN**: `12293`

## Spellbook

### SPELLBOOK\_SWAP

> **SPELLBOOK\_SWAP**: `3617`

If the player has a spellbook swap active
0 = inactive
1 = active

***

### SPELLBOOK

> **SPELLBOOK**: `4070`

***

### SPELLBOOK\_SUBMENU

> **SPELLBOOK\_SUBMENU**: `9730`

## Spicy Stew Ingredients

### SPICY\_STEW\_RED\_SPICES

> **SPICY\_STEW\_RED\_SPICES**: `1879`

***

### SPICY\_STEW\_YELLOW\_SPICES

> **SPICY\_STEW\_YELLOW\_SPICES**: `1880`

***

### SPICY\_STEW\_BROWN\_SPICES

> **SPICY\_STEW\_BROWN\_SPICES**: `1881`

***

### SPICY\_STEW\_ORANGE\_SPICES

> **SPICY\_STEW\_ORANGE\_SPICES**: `1882`

## Theatre of Blood

### THEATRE\_OF\_BLOOD

> **THEATRE\_OF\_BLOOD**: `6440`

Theatre of Blood 1=In Party, 2=Inside/Spectator, 3=Dead Spectating

***

### TOA\_RAID\_LEVEL

> **TOA\_RAID\_LEVEL**: `14380`

***

### TOA\_RAID\_DAMAGE

> **TOA\_RAID\_DAMAGE**: `14325`

## Theatre of Blood Orb Health

### THEATRE\_OF\_BLOOD\_ORB1

> **THEATRE\_OF\_BLOOD\_ORB1**: `6442`

0=hide 1-27=% of health - 27 is 100% health and 1 is 0% health, 30=dead

***

### THEATRE\_OF\_BLOOD\_ORB2

> **THEATRE\_OF\_BLOOD\_ORB2**: `6443`

***

### THEATRE\_OF\_BLOOD\_ORB3

> **THEATRE\_OF\_BLOOD\_ORB3**: `6444`

***

### THEATRE\_OF\_BLOOD\_ORB4

> **THEATRE\_OF\_BLOOD\_ORB4**: `6445`

***

### THEATRE\_OF\_BLOOD\_ORB5

> **THEATRE\_OF\_BLOOD\_ORB5**: `6446`

## Tithe Farm

### TITHE\_FARM\_SACK\_AMOUNT

> **TITHE\_FARM\_SACK\_AMOUNT**: `4900`

***

### TITHE\_FARM\_SACK\_ICON

> **TITHE\_FARM\_SACK\_ICON**: `5370`

***

### TITHE\_FARM\_POINTS

> **TITHE\_FARM\_POINTS**: `4893`

## Toggleable Slayer Unlocks

### SUPERIOR\_ENABLED

> **SUPERIOR\_ENABLED**: `5362`

***

### FOSSIL\_ISLAND\_WYVERN\_DISABLE

> **FOSSIL\_ISLAND\_WYVERN\_DISABLE**: `6251`

## Tombs of Amascut Orb Health

### TOA\_MEMBER\_0\_HEALTH

> **TOA\_MEMBER\_0\_HEALTH**: `14346`

0 = hide, 1-27 = % of health (27 is 100% health, 1 is 0% health), 30 = dead.

***

### TOA\_MEMBER\_1\_HEALTH

> **TOA\_MEMBER\_1\_HEALTH**: `14347`

***

### TOA\_MEMBER\_2\_HEALTH

> **TOA\_MEMBER\_2\_HEALTH**: `14348`

***

### TOA\_MEMBER\_3\_HEALTH

> **TOA\_MEMBER\_3\_HEALTH**: `14349`

***

### TOA\_MEMBER\_4\_HEALTH

> **TOA\_MEMBER\_4\_HEALTH**: `14350`

***

### TOA\_MEMBER\_5\_HEALTH

> **TOA\_MEMBER\_5\_HEALTH**: `14351`

## Tombs of Amascut Orb Health States

### TOA\_MEMBER\_6\_HEALTH

> **TOA\_MEMBER\_6\_HEALTH**: `14352`

***

### TOA\_MEMBER\_7\_HEALTH

> **TOA\_MEMBER\_7\_HEALTH**: `14353`

## Transmog Controllers for Farming

### FARMING\_4771

> **FARMING\_4771**: `4771`

***

### FARMING\_4772

> **FARMING\_4772**: `4772`

***

### FARMING\_4773

> **FARMING\_4773**: `4773`

***

### FARMING\_4774

> **FARMING\_4774**: `4774`

***

### FARMING\_4775

> **FARMING\_4775**: `4775`

***

### FARMING\_7904

> **FARMING\_7904**: `7904`

***

### FARMING\_7905

> **FARMING\_7905**: `7905`

***

### FARMING\_7906

> **FARMING\_7906**: `7906`

***

### FARMING\_7907

> **FARMING\_7907**: `7907`

***

### FARMING\_7908

> **FARMING\_7908**: `7908`

***

### FARMING\_7909

> **FARMING\_7909**: `7909`

***

### FARMING\_7910

> **FARMING\_7910**: `7910`

***

### FARMING\_7911

> **FARMING\_7911**: `7911`

***

### FARMING\_7912

> **FARMING\_7912**: `7912`

## Transmog Controllers for Grapes

### GRAPES\_4953

> **GRAPES\_4953**: `4953`

***

### GRAPES\_4954

> **GRAPES\_4954**: `4954`

***

### GRAPES\_4955

> **GRAPES\_4955**: `4955`

***

### GRAPES\_4956

> **GRAPES\_4956**: `4956`

***

### GRAPES\_4957

> **GRAPES\_4957**: `4957`

***

### GRAPES\_4958

> **GRAPES\_4958**: `4958`

***

### GRAPES\_4959

> **GRAPES\_4959**: `4959`

***

### GRAPES\_4960

> **GRAPES\_4960**: `4960`

***

### GRAPES\_4961

> **GRAPES\_4961**: `4961`

***

### GRAPES\_4962

> **GRAPES\_4962**: `4962`

***

### GRAPES\_4963

> **GRAPES\_4963**: `4963`

***

### GRAPES\_4964

> **GRAPES\_4964**: `4964`
