[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / [DeadZoneAPI](DeadZoneAPI.md) / GameEventType

# Enumeration: GameEventType

Contains a reference to all the game events. To use an event, copy the event name and define your own function making sure to include required parameters.
Events are important for reacting to what is changing in the game. For example, if you wanted to equip an item when the player animation changes to a specific one. You may use the [OnAnimationChanged](#onanimationchanged) event to listen for the change instead of checking the player's animation each game tick.
We recommend using the param decorator when data is required in an event as it provides clarity on what the event data represents inside the editor. In addition, you can right-click inside the editor -> Command Palette and search for the event name to insert a definition automatically

## Example

See how you can "subscribe" to a Runelite Event which takes an event parameter. Replace param below with a multi-line comment for editor type support
```
// @param {ChatMessage} event
function OnChatMessage(event) {
   if (event.getType() == ChatMessageType.GAMEMESSAGE) {
       Utility.print(event.getMessage());
   }
}
```

## Enumeration Members

### OnStart

> **OnStart**: `0`

Called when the script starts, should be used to setup variables

***

### OnGameTick

> **OnGameTick**: `1`

Called every game tick which is roughly 0.6s on the client thread

***

### OnShutdown

> **OnShutdown**: `2`

Called when the script shuts down, should be used to clean up any references

***

### OnChatMessage

> **OnChatMessage**: `3`

Called everytime a chat message is sent in the game chat

#### Param

[ChatMessage](DeadZoneAPI.Interface.ChatMessage.md)

***

### OnGameStateChanged

> **OnGameStateChanged**: `4`

Called when the game state changes such as logging in, changing worlds, loading etc

#### Param

[GameStateChanged](DeadZoneAPI.Interface.GameStateChanged.md)

***

### OnConfigChanged

> **OnConfigChanged**: `5`

Called when changes occor to a config item associated with community packages

#### Param

[ConfigChanged](#onconfigchanged)

***

### OnAnimationChanged

> **OnAnimationChanged**: `6`

Called when an actor's animation changes in the game

#### Param

[AnimationChanged](DeadZoneAPI.Interface.AnimationChanged.md)

***

### OnWidgetLoaded

> **OnWidgetLoaded**: `7`

Called when a widget was loaded such as your inventory or bank

#### Param

[WidgetLoaded](DeadZoneAPI.Interface.WidgetLoaded.md)

***

### OnProjectileMoved

> **OnProjectileMoved**: `8`

Called when a projectile has moved in the game, could be used for detecting when a projectile has spawned!

#### Param

[ProjectileMoved](DeadZoneAPI.Interface.ProjectileMoved.md)

***

### OnPlayerSpawned

> **OnPlayerSpawned**: `9`

Called when a player has spawned or became visible within render range

#### Param

[PlayerSpawned](DeadZoneAPI.Interface.PlayerSpawned.md)

***

### OnPlayerDespawned

> **OnPlayerDespawned**: `10`

Called when a player has logged out / died or is no longer within render range

#### Param

[PlayerDespawned](DeadZoneAPI.Interface.PlayerDespawned.md)

***

### OnActorDeath

> **OnActorDeath**: `11`

Called when a [Actor](DeadZoneAPI.Class.Actor.md) has died such as an [Npc](DeadZoneAPI.Class.NPC.md) or [Player](DeadZoneAPI.Interface.Player.md)

#### Param

[ActorDeath](DeadZoneAPI.Interface.ActorDeath.md)

***

### OnGameObjectSpawned

> **OnGameObjectSpawned**: `12`

Called when a Game Object is created or became visible within render range

#### Param

[GameObjectSpawned](DeadZoneAPI.Interface.GameObjectSpawned.md)

***

### OnGameObjectDespawned

> **OnGameObjectDespawned**: `13`

Called when a Game Object is removed or is no longer within render range

#### Param

[GameObjectDespawned](DeadZoneAPI.Interface.GameObjectDespawned.md)

***

### OnGroundObjectSpawned

> **OnGroundObjectSpawned**: `14`

Called when a Ground Object is created or became visible within render distance

#### Param

[GroundObjectSpawned](DeadZoneAPI.Interface.GroundObjectSpawned.md)

***

### OnGroundObjectDespawned

> **OnGroundObjectDespawned**: `15`

Called when a Ground Object is removed or is no longer within render range

#### Param

[GroundObjectDespawned](DeadZoneAPI.Interface.GroundObjectDespawned.md)

***

### OnWallObjectSpawned

> **OnWallObjectSpawned**: `16`

Called when a Wall Object is created or became visible within render distance

#### Param

[WallObjectSpawned](DeadZoneAPI.Interface.WallObjectSpawned.md)

***

### OnWallObjectDespawned

> **OnWallObjectDespawned**: `17`

Called when a Wall Object is removed or is no longer within render range

#### Param

[WallObjectDespawned](DeadZoneAPI.Interface.WallObjectDespawned.md)

***

### OnDecorativeObjectSpawned

> **OnDecorativeObjectSpawned**: `18`

Called when a Decorative Object is created or became visible within render distance

#### Param

[DecorativeObjectSpawned](DeadZoneAPI.Interface.DecorativeObjectSpawned.md)

***

### OnDecorativeObjectDespawned

> **OnDecorativeObjectDespawned**: `19`

Called when a Decorative Object is removed or is no longer within render range

#### Param

[DecorativeObjectDespawned](DeadZoneAPI.Interface.DecorativeObjectDespawned.md)

***

### OnNpcSpawned

> **OnNpcSpawned**: `20`

Called when a NPC spawns or became visible within render distance

#### Param

[NpcSpawned](DeadZoneAPI.Interface.NpcSpawned.md)

***

### OnNpcDespawned

> **OnNpcDespawned**: `21`

Called when a NPC is removed or is no longer within render range

#### Param

[NpcDespawned](DeadZoneAPI.Interface.NpcDespawned.md)

***

### OnMenuEntryAdded

> **OnMenuEntryAdded**: `22`

Called when any Menu Entry has been added. Please note, menu entries are added every frame / client tick! (roughly 20ms)

#### Param

[MenuEntryAdded](DeadZoneAPI.Interface.MenuEntryAdded.md)

***

### OnMenuOptionClicked

> **OnMenuOptionClicked**: `23`

Called when any Menu Entry has been clicked

#### Param

[MenuOptionClicked](DeadZoneAPI.Interface.MenuOptionClicked.md)

***

### OnClientTick

> **OnClientTick**: `24`

Called each client tick which is roughly every 20ms. Shouldn't be used for extensive logical operations, reserve for GameTick 

***

### OnGraphicsObjectCreated

> **OnGraphicsObjectCreated**: `25`

Called when a Graphics Object is created or became visible within render distance

#### Param

[GraphicsObjectCreated](DeadZoneAPI.Interface.GraphicsObjectCreated.md)

***

### OnMenuOpened

> **OnMenuOpened**: `26`

Called when a menu has been opened

#### Param

[MenuOpened](DeadZoneAPI.Interface.MenuOpened.md)

***

### OnStatChanged

> **OnStatChanged**: `27`

Called when the [LocalPlayer](DeadZoneAPI.Client.Function.getLocalPlayer.md)'s stat has changed

#### Param

[StatChanged](DeadZoneAPI.Interface.StatChanged.md)

***

### OnHitsplatApplied

> **OnHitsplatApplied**: `28`

Called when an [Actor](DeadZoneAPI.Class.Actor.md) has recieved [HitSplat](DeadZoneAPI.Interface.HitSplat.md) damage

#### Param

[HitsplatApplied](DeadZoneAPI.Interface.HitsplatApplied.md)

***

### OnFakeXPDrop

> **OnFakeXPDrop**: `29`

Called when [LocalPlayer](DeadZoneAPI.Client.Function.getLocalPlayer.md)'s has received a "fake" XP drop which doesn't have any impact on stats.

#### Param

[FakeXPDrop](DeadZoneAPI.Interface.FakeXPDrop.md)

***

### OnItemContainerChanged

> **OnItemContainerChanged**: `30`

Called when an [ItemContainer](DeadZoneAPI.Interface.ItemContainer.md) has changed such as your inventory or bank etc..

#### Param

[ItemContainerChanged](DeadZoneAPI.Interface.ItemContainerChanged.md)

***

### OnVarbitChanged

> **OnVarbitChanged**: `31`

Called when an [Varbit](DeadZoneAPI.Enumeration.Varbit.md) or [VarPlayer](DeadZoneAPI.Enumeration.VarPlayer.md) has changed

#### Param

[VarbitChanged](DeadZoneAPI.Interface.VarbitChanged.md)

***

### OnItemSpawned

> **OnItemSpawned**: `32`

Called when an [TileItem](DeadZoneAPI.Interface.TileItem.md) has spawned

#### Param

[ItemSpawned](DeadZoneAPI.Interface.ItemSpawned.md)

***

### OnItemDespawned

> **OnItemDespawned**: `33`

Called when an [TileItem](DeadZoneAPI.Interface.TileItem.md) has despawned

#### Param

[ItemDespawned](DeadZoneAPI.Interface.ItemDespawned.md)

***

### OnInteractingChanged

> **OnInteractingChanged**: `34`

Called when an [Actor](DeadZoneAPI.Class.Actor.md)'s interacting has changed

#### Param

[InteractingChanged](DeadZoneAPI.Interface.InteractingChanged.md)

***

### OnKeyPressed

> **OnKeyPressed**: `35`

Called when a key is pressed down

#### Param

Keycode which has been pressed
