[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / [DeadZoneAPI](DeadZoneAPI.md) / WorldPoint

# Class: WorldPoint

Represents a world position in the game on the x, y, and plane (z) axis.

## Implements

- `WorldPoint`

## Constructors

### Constructor

> **new WorldPoint**(`x`, `y`, `plane`): `WorldPoint`

Creates a new WorldPoint at the X and Y position

#### Parameters

##### x

`number`

the X position in the world

##### y

`number`

the Y position in the world

##### plane

`number`

the Z position in the world

#### Returns

`WorldPoint`

## Methods

### fromCoord()

> `static` **fromCoord**(`coord`): `WorldPoint`

#### Parameters

##### coord

`number`

#### Returns

`WorldPoint`

***

### isInScene()

> `static` **isInScene**(`worldView`, `x`, `y`): `boolean`

#### Parameters

##### worldView

[`WorldView`](DeadZoneAPI.Interface.WorldView.md)

##### x

`number`

##### y

`number`

#### Returns

`boolean`

***

### fromLocal()

> `static` **fromLocal**(`worldView`, `X`, `y`, `plane`): `WorldPoint`

#### Parameters

##### worldView

[`WorldView`](DeadZoneAPI.Interface.WorldView.md)

##### X

`number`

##### y

`number`

##### plane

`number`

#### Returns

`WorldPoint`

***

### toLocalInstance()

> `static` **toLocalInstance**(`worldView`, `worldPoint`): `WorldPoint`[]

#### Parameters

##### worldView

[`WorldView`](DeadZoneAPI.Interface.WorldView.md)

##### worldPoint

`WorldPoint`

#### Returns

`WorldPoint`[]

***

### fromLocalInstance()

> `static` **fromLocalInstance**(`scene`, `localPoint`, `plane`): `WorldPoint`

#### Parameters

##### scene

[`Scene`](DeadZoneAPI.Interface.Scene.md)

##### localPoint

[`LocalPoint`](DeadZoneAPI.Class.LocalPoint.md)

##### plane

`number`

#### Returns

`WorldPoint`

***

### getX()

> **getX**(): `number`

#### Returns

`number`

***

### getY()

> **getY**(): `number`

#### Returns

`number`

***

### getRegionID()

> **getRegionID**(): `number`

#### Returns

`number`

***

### getRegionX()

> **getRegionX**(): `number`

#### Returns

`number`

***

### getRegionY()

> **getRegionY**(): `number`

#### Returns

`number`

***

### getPlane()

> **getPlane**(): `number`

#### Returns

`number`

***

### distanceTo()

> **distanceTo**(`point`): `number`

#### Parameters

##### point

`WorldPoint`

#### Returns

`number`

***

### toWorldArea()

> **toWorldArea**(): [`WorldArea`](DeadZoneAPI.Class.WorldArea.md)

#### Returns

[`WorldArea`](DeadZoneAPI.Class.WorldArea.md)

***

### isInArea()

> **isInArea**(`worldAreas`): `boolean`

#### Parameters

##### worldAreas

[`WorldArea`](DeadZoneAPI.Class.WorldArea.md)[]

#### Returns

`boolean`

***

### isInArea2D()

> **isInArea2D**(`worldAreas`): `boolean`

#### Parameters

##### worldAreas

[`WorldArea`](DeadZoneAPI.Class.WorldArea.md)[]

#### Returns

`boolean`

***

### equals()

> **equals**(`point`): `boolean`

#### Parameters

##### point

`WorldPoint`

#### Returns

`boolean`

***

### toString()

> **toString**(): `string`

#### Returns

`string`
