[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / [DeadZoneAPI](DeadZoneAPI.md) / WorldArea

# Class: WorldArea

## Implements

- `WorldArea`

## Constructors

### Constructor

> **new WorldArea**(`x`, `y`, `width`, `height`, `plane`): `WorldArea`

Creates a new WorldArea at the X and Y world position

#### Parameters

##### x

`number`

the world X position, can use [WorldPoint](DeadZoneAPI.Class.WorldPoint.md) position

##### y

`number`

the world Y position, can use [WorldPoint](DeadZoneAPI.Class.WorldPoint.md) position

##### width

`number`

the width of the area from the X and Y position

##### height

`number`

the height of the area from the X and Y position

##### plane

`number`

the plane (Z) on which this area resides on, can use [WorldPoint](DeadZoneAPI.Class.WorldPoint.md) position

#### Returns

`WorldArea`

## Methods

### isEdgePoint()

> `static` **isEdgePoint**(`current`, `point`): `boolean`

#### Parameters

##### current

`WorldArea`

##### point

[`WorldPoint`](DeadZoneAPI.Class.WorldPoint.md)

#### Returns

`boolean`

***

### create()

> `static` **create**(`swLocation`, `neLocation`): `WorldArea`

Creates a new WorldArea from the south-west and north-east [WorldPoint](DeadZoneAPI.Class.WorldPoint.md)'s provided

#### Parameters

##### swLocation

[`WorldPoint`](DeadZoneAPI.Class.WorldPoint.md)

##### neLocation

[`WorldPoint`](DeadZoneAPI.Class.WorldPoint.md)

#### Returns

`WorldArea`

***

### calculateNextTravellingPoint()

> `static` **calculateNextTravellingPoint**(`origin`, `target`, `stopAtMeleeDistance`): `WorldArea`

Calculates the next travelling location from the origin area towards the target area using a similar walking algorithm by Jagex

#### Parameters

##### origin

`WorldArea`

##### target

`WorldArea`

##### stopAtMeleeDistance

`boolean`

#### Returns

`WorldArea`

***

### createFromWorldPoint()

> `static` **createFromWorldPoint**(`location`, `size`): `WorldArea`

Creates a new WorldArea from a [WorldPoint](DeadZoneAPI.Class.WorldPoint.md) expanding based on the size provided

#### Parameters

##### location

[`WorldPoint`](DeadZoneAPI.Class.WorldPoint.md)

##### size

`number`

#### Returns

`WorldArea`

***

### getX()

> **getX**(): `number`

#### Returns

`number`

***

### getY()

> **getY**(): `number`

#### Returns

`number`

***

### getWidth()

> **getWidth**(): `number`

#### Returns

`number`

***

### getHeight()

> **getHeight**(): `number`

#### Returns

`number`

***

### getPlane()

> **getPlane**(): `number`

#### Returns

`number`

***

### contains()

> **contains**(`other`): `boolean`

#### Parameters

##### other

[`WorldPoint`](DeadZoneAPI.Class.WorldPoint.md)

#### Returns

`boolean`

***

### contains2D()

> **contains2D**(`other`): `boolean`

#### Parameters

##### other

[`WorldPoint`](DeadZoneAPI.Class.WorldPoint.md)

#### Returns

`boolean`

***

### distanceTo()

> **distanceTo**(`other`): `number`

#### Parameters

##### other

`WorldArea`

#### Returns

`number`

***

### distanceTo2D()

> **distanceTo2D**(`other`): `number`

#### Parameters

##### other

`WorldArea`

#### Returns

`number`

***

### isInMeleeDistance()

> **isInMeleeDistance**(`other`): `boolean`

#### Parameters

##### other

`WorldArea`

#### Returns

`boolean`

***

### hasLineOfSightTo()

> **hasLineOfSightTo**(`current`, `other`): `boolean`

#### Parameters

##### current

[`WorldView`](DeadZoneAPI.Interface.WorldView.md)

##### other

`WorldArea`

#### Returns

`boolean`

***

### toWorldPoint()

> **toWorldPoint**(): [`WorldPoint`](DeadZoneAPI.Class.WorldPoint.md)

#### Returns

[`WorldPoint`](DeadZoneAPI.Class.WorldPoint.md)

***

### toWorldPointList()

> **toWorldPointList**(): [`WorldPoint`](DeadZoneAPI.Class.WorldPoint.md)[]

#### Returns

[`WorldPoint`](DeadZoneAPI.Class.WorldPoint.md)[]
