[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / [DeadZoneAPI](DeadZoneAPI.md) / RegionLocation

# Class: RegionLocation

Represents a region location in the game world

## Implements

- `RegionLocation`

## Constructors

### Constructor

> **new RegionLocation**(`x`, `y`, `id`): `RegionLocation`

Creates a new RegionLocation at the X and Y position with specified ID

#### Parameters

##### x

`number`

the X position in the region

##### y

`number`

the Y position in the region

##### id

`number`

the region ID

#### Returns

`RegionLocation`

## Methods

### toWorldPoint()

> `static` **toWorldPoint**(`regionLocation`): [`WorldPoint`](DeadZoneAPI.Class.WorldPoint.md)

Converts a RegionLocation to a [WorldPoint](DeadZoneAPI.Class.WorldPoint.md) using the provided client

#### Parameters

##### regionLocation

`RegionLocation`

#### Returns

[`WorldPoint`](DeadZoneAPI.Class.WorldPoint.md)

***

### getX()

> **getX**(): `number`

Returns the X position of this region location

#### Returns

`number`

#### Implementation of

`RegionLocation.getX`

***

### getY()

> **getY**(): `number`

Returns the Y position of this region location

#### Returns

`number`

#### Implementation of

`RegionLocation.getY`

***

### getId()

> **getId**(): `number`

Returns the ID of this region location

#### Returns

`number`

#### Implementation of

`RegionLocation.getId`

***

### isMatch()

> **isMatch**(`point`): `boolean`

Checks if the provided [WorldPoint](DeadZoneAPI.Class.WorldPoint.md) matches this region location

#### Parameters

##### point

[`WorldPoint`](DeadZoneAPI.Class.WorldPoint.md)

#### Returns

`boolean`

#### Implementation of

`RegionLocation.isMatch`
