[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / [DeadZoneAPI](DeadZoneAPI.md) / OverlayItem3DBuilder

# Class: OverlayItem3DBuilder

Builder class for creating 3D overlay items with a fluent API.
Allows configuring various properties such as NPCs, game objects, highlights, and text labels.

## Example

```typescript
var item = OverlayItem3D.builder()
               .addWorldPoint(wp)
               .highlightTile("#ad1010")
               .addText("DANGER!")
               .build();
```

## Constructors

### Constructor

> **new OverlayItem3DBuilder**(): `OverlayItem3DBuilder`

#### Returns

`OverlayItem3DBuilder`

## Methods

### addNpcByIndex()

> **addNpcByIndex**(`index`): `OverlayItem3DBuilder`

Adds an NPC to the overlay by its index.

#### Parameters

##### index

`number`

The index of the NPC to overlay.

#### Returns

`OverlayItem3DBuilder`

The current builder instance for method chaining.

***

### addWorldPoint()

> **addWorldPoint**(`worldpoint`): `OverlayItem3DBuilder`

Adds a world point location for the overlay.

#### Parameters

##### worldpoint

[`WorldPoint`](DeadZoneAPI.Class.WorldPoint.md)

A [WorldPoint](DeadZoneAPI.Class.WorldPoint.md) representing the location in the game world.

#### Returns

`OverlayItem3DBuilder`

The current builder instance for method chaining.

***

### addGameObject()

> **addGameObject**(`gameObject`): `OverlayItem3DBuilder`

Adds a game object to the overlay.

#### Parameters

##### gameObject

`any`

The game object to overlay.

#### Returns

`OverlayItem3DBuilder`

The current builder instance for method chaining.

***

### addPlayer()

> **addPlayer**(`player`): `OverlayItem3DBuilder`

Adds a player to the overlay.

#### Parameters

##### player

`any`

The player object to overlay.

#### Returns

`OverlayItem3DBuilder`

The current builder instance for method chaining.

***

### highlightTile()

> **highlightTile**(`color`): `OverlayItem3DBuilder`

Highlights the tile with the specified color.

#### Parameters

##### color

`string`

The color to use for highlighting the tile (e.g., "#FF0000").

#### Returns

`OverlayItem3DBuilder`

The current builder instance for method chaining.

***

### fillTile()

> **fillTile**(`color`): `OverlayItem3DBuilder`

Fills the tile with the specified color.

#### Parameters

##### color

`string`

The color to use for highlighting the tile (e.g., "#00FF00").

#### Returns

`OverlayItem3DBuilder`

The current builder instance for method chaining.

***

### highlightHull()

> **highlightHull**(`color`): `OverlayItem3DBuilder`

Highlights the hull (model outline) with the specified color.

#### Parameters

##### color

`string`

The color to use for highlighting the hull (e.g., "#00FF00").

#### Returns

`OverlayItem3DBuilder`

The current builder instance for method chaining.

***

### addText()

> **addText**(`text`): `OverlayItem3DBuilder`

Adds text to display with the overlay.

#### Parameters

##### text

`string`

The text label to display.

#### Returns

`OverlayItem3DBuilder`

The current builder instance for method chaining.

***

### setTickLifetime()

> **setTickLifetime**(`ticks`): `OverlayItem3DBuilder`

Sets the lifetime of the overlay in game ticks.
If not set, the overlay will persist indefinitely until removed.

#### Parameters

##### ticks

`number`

The number of game ticks the overlay should remain active.

#### Returns

`OverlayItem3DBuilder`

The current builder instance for method chaining.

***

### setFontSize()

> **setFontSize**(`size`): `OverlayItem3DBuilder`

Sets the font size for the overlay text.
If not set, the default font size is used.

#### Parameters

##### size

`number`

The font size in points (e.g., 20).

#### Returns

`OverlayItem3DBuilder`

The current builder instance for method chaining.

***

### setTextColor()

> **setTextColor**(`color`): `OverlayItem3DBuilder`

Sets the color of the overlay text independently from the tile/hull color.
If not set, the text color defaults to the tile or hull color.

#### Parameters

##### color

`string`

The hex color string for the text (e.g., "#00FF00").

#### Returns

`OverlayItem3DBuilder`

The current builder instance for method chaining.

***

### build()

> **build**(): `OverlayItem3DBuilder`

Builds and activates the 3D overlay with the configured properties.
Generates a unique UUID for the overlay and registers it with the overlay system.

#### Returns

`OverlayItem3DBuilder`

The current builder instance, allowing access to the [remove](#remove) method.

***

### remove()

> **remove**(): `void`

Removes the 3D overlay from the game world.
Call this method when the overlay is no longer needed.

#### Returns

`void`
