[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / [DeadZoneAPI](DeadZoneAPI.md) / OverlayItem3D

# Class: OverlayItem3D

Represents a 3D overlay item in the game world.
Use the [builder](#builder) method to create instances with a fluent API.

## Example

```typescript
// Create a 3D overlay highlighting an NPC with text
const overlay = OverlayItem3D.builder()
    .addNpcByIndex(5)
    .highlightTile("red")
    .addText("Target NPC")
    .build();

// Remove the overlay when done
overlay.remove();
```

## Constructors

### Constructor

> **new OverlayItem3D**(): `OverlayItem3D`

#### Returns

`OverlayItem3D`

## Methods

### builder()

> `static` **builder**(): [`OverlayItem3DBuilder`](DeadZoneAPI.Class.OverlayItem3DBuilder.md)

Creates a new builder instance for constructing a 3D overlay item.

#### Returns

[`OverlayItem3DBuilder`](DeadZoneAPI.Class.OverlayItem3DBuilder.md)

A new [OverlayItem3DBuilder](DeadZoneAPI.Class.OverlayItem3DBuilder.md) instance.
