[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / [DeadZoneAPI](DeadZoneAPI.md) / MenuEntry

# Class: MenuEntry

Creating a menu entry allows you to execute custom actions using the [action](DeadZoneAPI.Game.interact.Function.action.md) utility. You can find the menu entry for an action by enabling Developer Tools under Extras in DZ API and viewing the logs after performing an action then replicating the entry.  It's important you only action menu entries which are valid, so ensure you have replicated the values and identified any dynamic parts prior to sending them.

Dynamic values such as the index of the NPC you'd like to interact with or an object's position in the scene differs everytime. You can't provide static values for these type of interaction or your action will not function between different areas or after a client restart. To accomplish this, use the various helper methods available such as [GameObject Get All](DeadZoneAPI.Game.info.gameObject.Function.getAll.md) or [NPC Get All](DeadZoneAPI.Game.info.npc.Function.getAll.md) to grab them and retrieve the target value. For example, objects require their [SceneMinLocation](DeadZoneAPI.Interface.GameObject.md#getsceneminlocation) or [LocalLocation](DeadZoneAPI.Interface.TileObject.md#getlocallocation) ([SceneX](DeadZoneAPI.Class.LocalPoint.md#getscenex) / [SceneY](DeadZoneAPI.Class.LocalPoint.md#getsceney)) for param0 and param1 to interact with them.

We recommend using the [Interact](DeadZoneAPI.Game.Namespace.interact.md) utility for performing actions, unless unsupported.

## Implements

- `MenuEntry`

## Constructors

### Constructor

> **new MenuEntry**(`option`, `target`, `id`, `itemID`, `opCode`, `param0`, `param1`, `forceLeftClick`, `worldViewID`): `MenuEntry`

**`Internal`**

It's advisable to use the static methods [create](#create) or [createItem](#create) methods for new menu entries rather than the constructor!

#### Parameters

##### option

`string`

The left-side option of the menu, typically the action's name

##### target

`string`

The right-side option of the menu, typically the target's name

##### id

`number`

Typically refers to a unique index or ID

##### itemID

`number`

##### opCode

`number`

The [MenuAction](DeadZoneAPI.Enumeration.MenuAction.md) ID

##### param0

`number`

Typically a dynamic value

##### param1

`number`

Varies between static or dynamic depending on the interaction

##### forceLeftClick

`boolean`

Typically false, only set true for specific actions related to withdrawing / depositing from a bank and other minor instances

##### worldViewID

`number`

The world view this action is relates to. As of current, this value can be set to -1

#### Returns

`MenuEntry`

## Methods

### create()

> `static` **create**(`option`, `target`, `id`, `opCode`, `param0`, `param1`, `forceLeftClick`): `MenuEntry`

Create a new Menu Entry with the provided values

#### Parameters

##### option

`string`

The left-side option of the menu, typically the action's name

##### target

`string`

The right-side option of the menu, typically the target's name

##### id

`number`

Typically refers to a unique index or ID

##### opCode

`number`

The [MenuAction](DeadZoneAPI.Enumeration.MenuAction.md) ID

##### param0

`number`

Typically a dynamic value

##### param1

`number`

Varies between static or dynamic depending on the interaction

##### forceLeftClick

`boolean`

Typically false, only set true for specific actions related to withdrawing / depositing from a bank and other minor instances

#### Returns

`MenuEntry`

- A new Menu Entry with the provided values

***

### createItem()

> `static` **createItem**(`option`, `target`, `itemActionID`, `itemID`, `opCode`, `itemPosition`, `param1`, `forceLeftClick`): `MenuEntry`

Create a new Menu Entry for item interactions using the provided values

#### Parameters

##### option

`string`

The left-side option of the menu

##### target

`string`

The right-side option of the menu

##### itemActionID

`number`

The ID of the [ItemAction](DeadZoneAPI.Enumeration.ItemAction.md) you'd like to execute

##### itemID

`number`

The ID of the item you wish to interact with

##### opCode

`number`

Typically either [CC\_OP](DeadZoneAPI.Enumeration.MenuAction.md#cc_op) or [CC\_OP\_LOW\_PRIORITY](DeadZoneAPI.Enumeration.MenuAction.md#cc_op_low_priority) depending on the action

##### itemPosition

`number`

The item's position in your inventory starting at 0 for the top left slot. You can use [GetItemPosition](DeadZoneAPI.Game.info.inventory.Function.getItemPosition.md) method for dynamic position information

##### param1

`number`

Typically either [Normal](DeadZoneAPI.Constants.Variable.INVENTORY_ACTION_PARAM.md) or [Banking](DeadZoneAPI.Constants.Variable.INVENTORY_BANK_ACTION_PARAM.md) inventory param ID

##### forceLeftClick

`boolean`

Typically false, only set true for specific actions related to withdrawing / depositing from a bank and minor instances

#### Returns

`MenuEntry`

- A new Menu Entry with the provided values

***

### getWidget()

> **getWidget**(): [`Widget`](DeadZoneAPI.Interface.Widget.md)

#### Returns

[`Widget`](DeadZoneAPI.Interface.Widget.md)

***

### getNpc()

> **getNpc**(): [`NPC`](DeadZoneAPI.Class.NPC.md)

#### Returns

[`NPC`](DeadZoneAPI.Class.NPC.md)

***

### getPlayer()

> **getPlayer**(): [`Player`](DeadZoneAPI.Interface.Player.md)

#### Returns

[`Player`](DeadZoneAPI.Interface.Player.md)

***

### getActor()

> **getActor**(): [`Actor`](DeadZoneAPI.Class.Actor.md)

Returns an [Actor](DeadZoneAPI.Class.Actor.md) which could be of type [Npc](DeadZoneAPI.Class.NPC.md) or [Player](DeadZoneAPI.Interface.Player.md). Make use of [isNpc](DeadZoneAPI.Class.Actor.md#isnpc) or [isPlayer](DeadZoneAPI.Class.Actor.md#isplayer) to determine the type and use the static convert functions for editor clarity on the [Actor](DeadZoneAPI.Class.Actor.md) class

#### Returns

[`Actor`](DeadZoneAPI.Class.Actor.md)

## Properties

### option

> **option**: `string`

***

### target

> **target**: `string`

***

### id

> **id**: `number`

***

### opCode

> **opCode**: `number`

***

### param0

> **param0**: `number`

***

### param1

> **param1**: `number`

***

### worldViewId

> **worldViewId**: `number`

***

### forceLeftClick

> **forceLeftClick**: `boolean`

***

### itemID

> **itemID**: `number`

***

### type

> **type**: [`MenuAction`](DeadZoneAPI.Enumeration.MenuAction.md)
