[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / [DeadZoneAPI](DeadZoneAPI.md) / LocalPoint

# Class: LocalPoint

Represents a local position in the game on the x and y axis

## Implements

- `LocalPoint`

## Constructors

### Constructor

> **new LocalPoint**(`x`, `y`, `worldView`): `LocalPoint`

Creates a new LocalPoint at the X and Y position

#### Parameters

##### x

`number`

the X position in the scene

##### y

`number`

the Y position in the scene

##### worldView

`number`

the world view this local point relates to, typically -1 for top level

#### Returns

`LocalPoint`

## Methods

### fromWorld()

> `static` **fromWorld**(`worldView`, `worldPoint`): `LocalPoint`

#### Parameters

##### worldView

[`WorldView`](DeadZoneAPI.Interface.WorldView.md)

##### worldPoint

[`WorldPoint`](DeadZoneAPI.Class.WorldPoint.md)

#### Returns

`LocalPoint`

***

### fromScene()

> `static` **fromScene**(`x`, `y`, `worldView`): `LocalPoint`

#### Parameters

##### x

`number`

##### y

`number`

##### worldView

[`WorldView`](DeadZoneAPI.Interface.WorldView.md)

#### Returns

`LocalPoint`

***

### getX()

> **getX**(): `number`

#### Returns

`number`

***

### getY()

> **getY**(): `number`

#### Returns

`number`

***

### getSceneX()

> **getSceneX**(): `number`

#### Returns

`number`

***

### getSceneY()

> **getSceneY**(): `number`

#### Returns

`number`

***

### getWorldView()

> **getWorldView**(): [`WorldView`](DeadZoneAPI.Interface.WorldView.md)

#### Returns

[`WorldView`](DeadZoneAPI.Interface.WorldView.md)

***

### distanceTo()

> **distanceTo**(`point`): `number`

#### Parameters

##### point

`LocalPoint`

#### Returns

`number`

***

### equals()

> **equals**(`point`): `boolean`

#### Parameters

##### point

`LocalPoint`

#### Returns

`boolean`

***

### toString()

> **toString**(): `string`

#### Returns

`string`

## Properties

### x

> **x**: `number`

***

### y

> **y**: `number`

***

### worldView

> **worldView**: `number`
