[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / [DeadZoneAPI](DeadZoneAPI.md) / ConfigItem

# Class: ConfigItem

Create a config item which will be editable by users through the package config manager

## Constructors

### Constructor

> **new ConfigItem**(`key`, `section`, `name`, `desc`, `defaultValue`): `ConfigItem`

Ignore, don't use the constructor directly! Use the static methods such as [createBoolean](#createboolean) or [createString](#createstring) etc..

#### Parameters

##### key

`string`

##### section

`string`

##### name

`string`

##### desc

`string`

##### defaultValue

`string`

#### Returns

`ConfigItem`

## Methods

### createBoolean()

> `static` **createBoolean**(`key`, `section`, `name`, `desc`, `defaultValue`): `ConfigItem`

Create a config item which will be editable by users through the package config manager

#### Parameters

##### key

`string`

a unique string associated with the config item to identify it amongst others

##### section

`string`

the section the items falls under in the config

##### name

`string`

display name of the config item

##### desc

`string`

define a small description for the config item

##### defaultValue

`boolean`

the default value your config item presents, it can be anything in-line with your data type

#### Returns

`ConfigItem`

***

### createString()

> `static` **createString**(`key`, `section`, `name`, `desc`, `defaultValue`): `ConfigItem`

Create a config item which will be editable by users through the package config manager

#### Parameters

##### key

`string`

a unique string associated with the config item to identify it amongst others

##### section

`string`

the section the items falls under in the config

##### name

`string`

display name of the config item

##### desc

`string`

define a small description for the config item

##### defaultValue

`string`

the default value your config item presents, it can be anything in-line with your data type

#### Returns

`ConfigItem`

***

### createInteger()

> `static` **createInteger**(`key`, `section`, `name`, `desc`, `defaultValue`): `ConfigItem`

Create a config item which will be editable by users through the package config manager

#### Parameters

##### key

`string`

a unique string associated with the config item to identify it amongst others

##### section

`string`

the section the items falls under in the config

##### name

`string`

display name of the config item

##### desc

`string`

define a small description for the config item

##### defaultValue

`number`

the default value your config item presents, it can be anything in-line with your data type

#### Returns

`ConfigItem`

***

### createIntegerRange()

> `static` **createIntegerRange**(`key`, `section`, `name`, `desc`, `rangeMin`, `rangeMax`, `defaultValue`): `ConfigItem`

Create a config item which will be editable by users through the package config manager

#### Parameters

##### key

`string`

a unique string associated with the config item to identify it amongst others

##### section

`string`

the section the items falls under in the config

##### name

`string`

display name of the config item

##### desc

`string`

define a small description for the config item

##### rangeMin

`number`

for integer types, define the minimum value a user can input

##### rangeMax

`number`

for integer types, define the maximum value a user can input

##### defaultValue

`number`

the default value your config item presents, it can be anything in-line with your data type

#### Returns

`ConfigItem`

***

### createList()

> `static` **createList**(`key`, `section`, `name`, `desc`, `listContent`, `defaultValue`): `ConfigItem`

Create a config item which will be editable by users through the package config manager

#### Parameters

##### key

`string`

a unique string associated with the config item to identify it amongst others

##### section

`string`

the section the items falls under in the config

##### name

`string`

display name of the config item

##### desc

`string`

define a small description for the config item

##### listContent

`string`[]

for list types, an array of items which be selectable in the dropdown menu

##### defaultValue

`string`

the default value your config item presents, it can be anything in-line with your data type

#### Returns

`ConfigItem`

***

### createWorldPoint()

> `static` **createWorldPoint**(`key`, `section`, `name`, `desc`, `defaultValue`): `ConfigItem`

Create a config item which will be editable by users through the package config manager

#### Parameters

##### key

`string`

a unique string associated with the config item to identify it amongst others

##### section

`string`

the section the items falls under in the config

##### name

`string`

display name of the config item

##### desc

`string`

define a small description for the config item

##### defaultValue

`boolean`

the default value your config item presents, format: new WorldPoint(x, y, z) OR null to show 'not set'

#### Returns

`ConfigItem`

***

### createKeyBind()

> `static` **createKeyBind**(`key`, `section`, `name`, `desc`, `defaultValue`): `ConfigItem`

Create a config item which will be editable by users through the package config manager

#### Parameters

##### key

`string`

a unique string associated with the config item to identify it amongst others

##### section

`string`

the section the items falls under in the config

##### name

`string`

display name of the config item

##### desc

`string`

define a small description for the config item

##### defaultValue

`boolean`

the default value your config item, as a key string such as "F1" or "Escape"

#### Returns

`ConfigItem`

***

### createButton()

> `static` **createButton**(`key`, `section`, `name`, `desc`, `functionName`): `ConfigItem`

Create a config item which will be editable by users through the package config manager

#### Parameters

##### key

`string`

a unique string associated with the config item to identify it amongst others

##### section

`string`

the section the items falls under in the config

##### name

`string`

display name of the config item

##### desc

`string`

define a small description for the config item

##### functionName

`string`

the name of the function to call when the config item is changed, as a string

#### Returns

`ConfigItem`

***

### getKey()

> **getKey**(): `string`

#### Returns

`string`

***

### getSection()

> **getSection**(): `string`

#### Returns

`string`

***

### getName()

> **getName**(): `string`

#### Returns

`string`

***

### getDesc()

> **getDesc**(): `string`

#### Returns

`string`

***

### getDataType()

> **getDataType**(): [`ConfigType`](DeadZoneAPI.Enumeration.ConfigType.md)

#### Returns

[`ConfigType`](DeadZoneAPI.Enumeration.ConfigType.md)

***

### getDefaultValue()

> **getDefaultValue**(): `any`

#### Returns

`any`

***

### getValue()

> **getValue**(): `any`

Returns the current value associated with this config item

#### Returns

`any`

***

### setValue()

> **setValue**(`value`): `void`

Overrides the value associated with this config item

#### Parameters

##### value

`any`

#### Returns

`void`
