[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / [Community Guides](Document.Community-Guides.md) / Getting Started with DeadZone Community Packages

# Getting Started with DeadZone Community Packages

Welcome to DeadZone Community Packages! This guide will help you get started with creating custom plugins for Old School RuneScape using the DeadZone API.

## What are Community Packages?

Community Packages are user-created JavaScript plugins that run within the DeadZone/RuneLite client. They allow you to automate tasks, create custom interfaces, and interact with the game in powerful ways using the comprehensive DeadZone API.

## Prerequisites

Before you begin, you'll need:

1. **RuneLite Client with DeadZone Subscription** - DeadZone needs to be launched and authenticated to work with the API.
2. **Access to deadzone.dev** - This is the web-based development environment where you'll create and test your packages
3. **Basic JavaScript Knowledge** - While not strictly required, familiarity with JavaScript will help you understand the examples and create more complex plugins

## Accessing the Development Environment

1. Open your web browser and navigate to **https://deadzone.dev**
2. Sign in with Discord
3. You'll be greeted with the Community Packages dashboard

## Understanding the Dashboard

The deadzone.dev dashboard is your central hub for managing packages:

### Main Sections

- **Store** - Browse packages shared by the community
- **Collection** - View and manage all your created packages
- **Manage** - View and manage package sales/statistics and reset trials
- **Documentation** - Access the complete API reference

## Key Concepts

### Package Structure

Every Community Package consists of three main components:

1. **main.js** - The core logic of your plugin with event handlers and main functionality
2. **config.js** - Configuration options that users can customize through the UI
3. **utils.js** (optional) - Utility code, helper code. Mainly to keep the main.js file clean(er).

### The Plugin Lifecycle

Community Packages follow a specific lifecycle:

```
User Clicks Start → OnStart() is called
    ↓
Package runs and responds to events like OnGameTick()
    ↓
User Clicks Stop → OnShutdown() is called
```

### Core Events

Every package should implement these essential event handlers:

- **OnStart()** - Called when the plugin starts. Initialize variables and setup here.
- **OnGameTick()** - Called every ~600ms (0.6secs) game tick. Main logic goes here.
- **OnClientTick()** - Called every ~20ms Rarely used only for intensive fast demanding logic. Game interactions should not really be done here.
- **OnShutdown()** - Called when the plugin stops. Clean up resources here.

[Click Here for Full Event List](https://api.deadzone.wiki/enums/DeadZoneAPI.GameEventType.html)

## Your First Look at the API

The DeadZone API provides powerful namespaces for interacting with the game:

### Game Namespace
Access game information and perform actions:
```javascript
Game.info.inventory.getItems()  // Get all inventory items
Game.interact.npc.attack(npc)   // Attack an NPC
Game.sendGameMessage("Hello!", "My Plugin")  // Send a chat message
```

### Client Namespace
Access client and player information:
```javascript
Client.getLocalPlayer()         // Get your player
Client.getRealSkillLevels(Skill.ATTACK)  // Get your attack level
```

### PlayerHelper Namespace
Perform player actions:
```javascript
PlayerHelper.walkTo(worldPoint)       // Walk to a location
PlayerHelper.activatePrayer(Prayer.PROTECT_FROM_MELEE)  // Activate prayer
```

### Utility Namespace
Helpful utility functions:
```javascript
Utility.print("Debug message")  // Print to console
Utility.getDelay()              // Get user's configured DZ API Delay
Utility.pressKey("H")      // Simulate key "H" Press
```

## Testing Your Package

When you create or edit a package:

1. Click **Save** to save your code
2. Click **Start** to run the package in-game
3. Monitor the **Console** tab for any errors or debug messages
4. Use the **Stop** button to halt execution

## Best Practices

### Safety First
- Always implement proper error handling
- Test extensively before publishing
- Never skip required event handlers (OnStart, OnShutdown)

### User Experience
- Provide clear configuration options
- Add overlay displays for status information
- Use descriptive names and comments in your code

### Performance
- Avoid expensive operations in OnGameTick()/OnClientTick() when possible
- Use appropriate delays between actions
- Cache frequently accessed data

## Common Pitfalls

1. **Missing OnShutdown()** - Always clean up resources when stopping
2. **Client Thread Issues** - Some methods require Client.invokeLater() wrapper
3. **Hardcoded Values** - Use config items instead of hardcoded settings
4. **No Error Handling** - Always wrap risky operations in try-catch blocks

## Getting Help

### Resources
- **API Documentation** - https://api.deadzone.wiki/ - Complete API reference with examples
- **Community Discord** - Ask questions and share your creations
- **Example Packages** - Study published packages to learn patterns

### Debug Tools
- **Utility.print()** - Output debug information to console
- **Game.sendGameMessage()** - Display messages in game chat
- **Debug Mode** - Add a debug config option to enable verbose logging

## Next Steps

Now that you understand the basics, you're ready to:

1. **Create Your First Plugin** - Follow the "Creating Your First Plugin" guide to build a simple package without coding
2. **Learn About Configs** - Understand how to add user-configurable options
3. **Explore Overlays** - Add visual displays to your plugin
4. **Study the API** - Dive deep into the comprehensive DeadZone API documentation

---

**Ready for more?** Continue to [Creating Your First Plugin](Community-Guides.Document.Creating-Your-First-Plugin-(No-Coding-Required).md) to build your first package step-by-step.
