[**DeadZone Community Packages**](README.md)

***

[DeadZone Community Packages](README.md) / [Community Guides](Document.Community-Guides.md) / Creating Your First Plugin (No Coding Required)

# Creating Your First Plugin (No Coding Required)

This guide will walk you through creating your first DeadZone Community Package using the web interface at deadzone.dev. **No coding experience required!** We'll explore the interface, understand the structure, and get your first plugin running.

## What We'll Create

In this tutorial, you'll create a simple "Welcome Message" plugin that:
- Displays a welcome message when started
- Shows a goodbye message when stopped
- Teaches you the basics of the package interface

## Step 1: Access the Development Portal

1. Open your web browser and navigate to **https://deadzone.dev**
2. Log in with your Discord
3. You should see the main dashboard with your packages list

## Step 2: Create a New Package

1. Go to Collection -> Private (This is where your unreleased plugins will be!)
2. Click the **"Create Package"** button (usually near the top)
3. You'll see a form with several fields:

### Package Details Form

Fill in the following information:

- **Package Name**: `My First Plugin`
  - This is what users will see in the package list
  - Use a descriptive, memorable name

- **Description**: `A simple welcome plugin to learn the basics`
  - Brief explanation of what your plugin does
  - Helps others understand your package's purpose

- **Package Type**: `Utility`
  - Choose the category that best fits your plugin
  - Options typically include: Skilling, PvM, Utility, Skilling

3. Click **"Create"** to proceed to the editor

**Note: You cannot publish a package if it does not have an image or a long enough description**

## Step 3: Understanding the Editor Interface

After creating your package, you'll see the Package Editor with several tabs:

### Editor Tabs Overview

#### 1. main.js Tab
- Contains the main logic of your plugin
- Where event handlers like OnStart, OnGameTick, and OnShutdown live
- This is the "brain" of your plugin

#### 2. utils.js Tab
- Useful helper/utility functions
- Should not really contain event handlers, but assist in reduction of filesize/length of the main.js file
- Generally should help make code more readable/manageable.

#### 3. config.js Tab
- Defines user-configurable options
- Allows users to customize your plugin's behavior
- Creates the settings panel in-game
- 2D Overlay configuration.

#### 4. Metadata Tab
- Configure package metadata
- Set permissions and visibility
- Manage version information
- Edit the store page itself.
- **This is a similar page to when you first created your plugin, but with the ability to access/edit the store page listing itself**

## Step 4: Exploring the Default Code

When you create a new package, it comes with template code. Let's understand what's there:

### The main.js File

Click on the **main.js** tab. You'll see something like this:

```javascript
function OnStart() {
    // Called when the plugin starts
}

function OnGameTick() {
    // Called every game tick (~600ms)
}

function OnShutdown() {
    // Called when the plugin stops
}
```

**What each function does:**

- **OnStart()**: Runs once when you click the "Start" button. Perfect for:
  - Initializing variables
  - Sending welcome messages
  - Setting up initial state

- **OnGameTick()**: Runs repeatedly every game tick (approximately every 600 milliseconds). Use for:
  - Main plugin logic
  - Checking game state
  - Performing actions

- **OnShutdown()**: Runs once when you click the "Stop" button. Use for:
  - Cleanup tasks
  - Saving data
  - Sending goodbye messages

### The config.js File

Click on the **config.js** tab. You'll see:

```javascript
const config = {
    // Configuration items go here
};

const overlay = {
    // Overlay items go here
};
```

**What this means:**

- **config**: An object that holds all user-configurable settings
- **overlay**: An object that defines what information displays on-screen

## Step 5: No-Code Exploration Tasks

Let's explore the interface without writing code. Follow these steps:

### Task 1: Navigate Between Tabs

1. Click through each tab: main.js, utils.js, config.js, Metadata
2. Notice how each tab has a different purpose
3. Familiarize yourself with where everything is located

### Task 2: Review Settings

1. Click on the **Metadata** tab
2. You'll see fields like:
   - **Package Name**
   - **Description**
   - **Version** (if it was released prior to a new game revision)
   - **Tags/Categories**
3. These can be changed later without affecting code

### Task 3: Save Your Package

1. Click the **"Save"** button (usually at the top right)
2. You should see a confirmation message: "Package saved successfully"
3. Your package is now stored and ready to use

## Step 4: Starting Your Plugin (In-Game)

Now let's see your plugin in action:

1. **Make sure you're logged into OSRS** with RuneLite + DeadZone plugin active
2. Open the DeadZone Tab in the DZClient you should see a list of packages to "Download". Download the package and then you should see it appear in the "Installed" tab. This is now very similar to a RuneLite plugin - you can see/edit plugin configuration from the client, and start/stop it.

### What's Happening?

Even though our plugin doesn't do anything yet, it's running! The OnGameTick() function is being called every game tick, and the plugin is "alive."

### What's Happening?

When you stop the plugin, OnShutdown() is called, and the plugin ceases all operations.

## Step 5: Understanding the Package Lifecycle (Visual)

Let's visualize what happens when you interact with your plugin:

```
┌─────────────────────────────────────────────────────┐
│  User clicks "Start" in DZClient                    │
└─────────────────┬───────────────────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────────────────┐
│  OnStart() is called ONCE                            │
│  • Initialize variables                              │
│  • Send startup messages                             │
│  • Setup initial state                               │
└─────────────────┬───────────────────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────────────────┐
│  OnGameTick() is called REPEATEDLY                   │
│  • Every ~600ms                                      │
│  • Main plugin logic runs here                       │
│  • Checks game state and performs actions            │
└─────────────────┬───────────────────────────────────┘
                  │  (loops continuously)
                  │
                  ▼
┌─────────────────────────────────────────────────────┐
│  User clicks "Stop" in DZClient                     │
└─────────────────┬───────────────────────────────────┘
                  │
                  ▼
┌─────────────────────────────────────────────────────┐
│  OnShutdown() is called ONCE                         │
│  • Cleanup resources                                 │
│  • Save any data                                     │
│  • Send goodbye messages                             │
└─────────────────────────────────────────────────────┘
                  │
                  ▼
                Package is stopped
```

## Step 6: Exploring Example Packages

One of the best ways to learn is by studying existing packages:

1. Navigate to https://api.deadzone.wiki/index.html 
2. Browse through "Documents"
3. Most of these resources will be code from a DeadZone Developer.

### What to Look For

When studying examples:

- **Structure**: Notice how OnStart, OnGameTick, and OnShutdown are used
- **Configs**: See how other developers create configuration options
- **Overlays**: Observe how status information is displayed
- **Comments**: Read comments to understand the developer's thinking

## Step 7: Common Interface Features

Let's explore other useful features in the interface:

### Feature 1: Code Syntax Highlighting

- Notice how different parts of code have different colors
- Keywords (like `function`, `const`) are one color
- Strings (text in quotes) are another color
- This helps you read code more easily

### Feature 2: Fast-Save (if available)

- If you enter code you should see that "Save" button appears a different colour.
- You can press ctrl + s and it will perform a quick save.

### Feature 3: Version History

- Look at the top panel near main.js, utils.js, config.js, Metadata, it should say "Local Changes" This is a dropdown.
- You should be able to click on the dropdown and see a list of 10(ish) recent saves. This is similar to Git Commit History. Allowing you to go back a version or compare versions.

## Step 8: Best Practices (No Coding Yet!)

Even without writing code, there are best practices to follow:

### Naming Conventions

- Use descriptive names: "Welcome Bot" is better than "Plugin1"
- Avoid special characters in package names
- Keep names concise but meaningful

### Organization

- Keep related packages together (use naming prefixes)
- Use version numbers consistently
- Write clear descriptions

### Testing

- Always test on a non-critical account first
- Test starting and stopping multiple times
- Check that the plugin stops cleanly

### Documentation

- Keep notes about what your plugin does
- Document any setup requirements
- Note any known issues or limitations

## Step 9: Troubleshooting Common Issues

Even without coding, you might encounter issues:

### Issue: Can't See Package In-Game

**Solution:**
- Ensure DeadZone plugin is active in RuneLite
- Check that you're logged into the same account
- Refresh the package list in the DeadZone panel

### Issue: Package Won't Start

**Solution:**
- Check Console tab for errors
- Verify you have the latest DeadZone plugin version
- Make sure OSRS is running and logged in

### Issue: Changes Not Taking Effect

**Solution:**
- Stop the package completely
- Save your changes in deadzone.dev
- Click the refresh/download button in the DZ Plugin Tab in DZClient
- Start the package again

## Congratulations!

You've successfully:
- ✅ Created your first package
- ✅ Navigated the deadzone.dev interface
- ✅ Understood the plugin lifecycle
- ✅ Started and stopped a package in-game
- ✅ Explored example packages
- ✅ Learned best practices

## Next Steps

Now that you're comfortable with the interface, you're ready to:

1. **Add Functionality** - Follow the "How to Make a Chatbot Plugin" guide to add your first code
2. **Learn About Configs** - Create user-configurable options
3. **Add Overlays** - Display information on-screen
4. **Study the API** - Dive into the DeadZone API documentation

## Quick Reference Card

Keep this handy as you work:

| Tab | Purpose |
|-----|---------|
| main.js | Core plugin logic and event handlers |
| utils.js | Helper Code to help the main.js be more readable/workable |
| config.js | User settings and overlay definitions |
| Metadata | Package metadata and configuration |

| Button | Action |
|--------|--------|
| Save | Save current code changes |
| Start | Begin running the plugin in-game |
| Stop | Halt the plugin and call OnShutdown() |
| Delete | Permanently remove the package |

| Function | When Called | Purpose |
|----------|-------------|---------|
| OnStart() | Plugin starts | Initialize and setup |
| OnGameTick() | Every ~600ms | Main logic loop |
| OnShutdown() | Plugin stops | Cleanup and save |

---

**Ready to add code?** Continue to [How to Make a Chatbot Plugin](Community-Guides.Document.How-to-Make-a-Chatbot-Plugin.md) for your first coding experience!
